/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import java.util.Stack;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.Function;

public class PropertyInfo {
    private Property.Maker maker;
    private PropertyList plist;
    private FObj fo;
    private Stack stkFunction;

    public PropertyInfo(Property.Maker maker, PropertyList propertyList, FObj fObj) {
        this.maker = maker;
        this.plist = propertyList;
        this.fo = fObj;
    }

    public int currentFontSize() {
        return this.plist.get("font-size").getLength().mvalue();
    }

    public FObj getFO() {
        return this.fo;
    }

    private PercentBase getFunctionPercentBase() {
        Function function;
        if (this.stkFunction != null && (function = (Function)this.stkFunction.peek()) != null) {
            return function.getPercentBase();
        }
        return null;
    }

    public PercentBase getPercentBase() {
        PercentBase percentBase = this.getFunctionPercentBase();
        return percentBase != null ? percentBase : this.maker.getPercentBase(this.fo, this.plist);
    }

    public PropertyList getPropertyList() {
        return this.plist;
    }

    public boolean inheritsSpecified() {
        return this.maker.inheritsSpecified();
    }

    public void popFunction() {
        if (this.stkFunction != null) {
            this.stkFunction.pop();
        }
    }

    public void pushFunction(Function function) {
        if (this.stkFunction == null) {
            this.stkFunction = new Stack();
        }
        this.stkFunction.push(function);
    }
}

