#ifndef __PREFEROSD_H
#define __PREFEROSD_H

#include <vdr/plugin.h>

static const int BORDERSIZE = 2;
#if VDRVERSNUM >= 10307
static const cFont *font = cFont::GetFont(fontOsd);
static const int LINEHEIGHT = font->Height();
#else
static const int LINEHEIGHT = cOsd::LineHeight();
#endif

#if VDRVERSNUM < 10307
typedef eDvbColor tColor;
#endif

class cPreferOsd : public cOsdObject {
private:
#if VDRVERSNUM >= 10307
  cOsd *osd;
#else
  cOsdBase *osd;
  cBitmap  *bitmap;
  int WindowHandle;
#endif
  tChannelID lastChannel;
  
public:
  cPreferOsd(void);
  ~cPreferOsd();
  virtual void Show(void);
  virtual eOSState ProcessKey(eKeys Key);
  
  void ReadPreferedChannels(void);
  
  void CursorUp();
  void CursorDown();
  void CursorLeft();
  void CursorRight();
  void CursorOK();
  void LastChannel();
  void AddChannel();
  void RemoveChannel();
  
  void DisplayPreferMenu(void); 

private:
  void DrawPreferMenu(int delta, int highlight);
  void DrawChannelsNames(int delta);
#if VDRVERSNUM >= 10307
  void DrawSymbol(int x, int y, char *SymbolName[], tColor color);
#else
  void DrawSymbol(int x, int y, int symbol, tColor color);
#endif
  void DrawHLine(int xstart, int ystart, int width, tColor color);
  void DrawVLine(int xstart, int ystart, int height, tColor color);
};

#endif //__PREFEROSD_H
