/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb_checkbutton.h>
#include <vdkb/vdkb_evbox.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_form.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_objinspect.h>
#include <vdkb/vdkb_prjman.h>
#include <stdlib.h>
#include <vdkb/vdkb_fixed.h>

/*
================================
symbolic constants to templatize
a bit 
================================
*/
// for methods and other stuff
#define CLASS VDKBCheckButton
// put here vdk class name string
#define VDK_CLASS "VDKCheckButton"
// put here vdk class name 
#define VDK_ANCESTOR  VDKCheckButton
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "checkbutton"

//=================================================================

extern char *wi_widget_prompts[];
static char buff[128];
// used to autogenerate default
int CLASS::Counter = 0;
/* 
 properties,signals and nicknames
*/
char* vdkcheckbutton_props[] = {  CAPTION,CAPTIONWRAP,0 };
char* vdkcheckbutton_signals[] = { SIGNAL_TOGGLED,0 };
char* vdkcheckbutton_nicknames[] = { NICK_TOGGLED,0 };
//////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDK_ANCESTOR);
DEFINE_EVENT_LIST(CLASS,VDK_ANCESTOR);
//////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, VDKForm* owner,
	     char* label, char* tip = NULL):
  VDKCheckButton(owner,label,tip),VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add to VDKBObject properties list
  for(t=0; vdkcheckbutton_props[t]; t++)
    proplist.add(VDKBProperty(vdkcheckbutton_props[t]));
  // add to VDKBObject signal list 
  for(t=0; vdkcheckbutton_signals[t]; t++)
    siglist.add(VDKBSignal(vdkcheckbutton_signals[t],
			   this,
			   vdkcheckbutton_nicknames[t]));
  // connects common events.
  CONNECT_COMMON_EVENTS
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
  //
  if(label)
    SetPropValue( CAPTION,label);
}
/////////////////////////////////////
//
//          WRITE TO .FRM FILE
//
/////////////////////////////////////
/*
Writes a .frm format representation of label button widget
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  //============================
  // USER STUFF BEGINS HERE
  // writes specific properties
  fprintf(fp,"\n\t%s\"%s\";",PROP_CAPTION,(char*) GetProp( CAPTION));
  fprintf(fp,"\n\t%s%s;",PROP_CAPTIONWRAP,(char*) GetProp( CAPTIONWRAP));
}
////////////////////////////////////////
//
//        PREPARE GUI WIDGETS
//
////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
 */
		       
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable counter
  // to ensure unicity
  CLASS* button;
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2; 
  else
    // actually makes widget
    button = new CLASS(buff,owner,buff);
  // add widget to form
  return owner->AddToSelf(button,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  char obj_caption[128];
  // gets widget name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return NULL;
  bool nls_support = parser.CheckNLSSupport();
  source = new char[4096];
  if(!parser.GetParam(obj_caption,buffer,PROP_CAPTION))
    strcpy(obj_caption,"none");
  if(nls_support)
    sprintf(tmp,"\n%s = new %s(this,_(\"%s\"));",
	    obj_name,
	    VDK_CLASS,
	    obj_caption);
  else
    sprintf(tmp,"\n%s = new %s(this,\"%s\");",
	    obj_name,
	    VDK_CLASS,
	    obj_caption);
  strcpy(source,tmp);
  ///////////////////////////////////////
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
  // set widget specific properties
  // get label button  props
  if(parser.GetParam(arg,buffer,PROP_CAPTIONWRAP) && 
     strcmp(arg,NIHIL_PROP)
     )
   {
     sprintf(tmp,"\n%s->%s = %s;",obj_name,CAPTIONWRAP,arg);
     strcat(source,tmp);
   }    
  // get code that adds widget to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner, 
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char obj_caption[256];
  char arg[64];
  CLASS* button;
  // get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return false;
  // get caption
  if(!parser.GetParam(obj_caption,buffer,PROP_CAPTION))
    strcpy(obj_caption,"none");
  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ? 
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      button = new CLASS(obj_name,owner,obj_caption);
      if(
	 parser.GetParam(arg,buffer,PROP_CAPTIONWRAP) &&
	 strcmp(arg,NIHIL_PROP)
	 )
	{
	button->CaptionWrap = !strcmp(arg,CHECK_TRUE);
	button->SetPropValue(CAPTIONWRAP,arg);
	}
      // pack widget to container
      return owner->PackToSelf(button, container, buffer, parser);
    }
  else
    return false;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
 */
VDKObjectContainer* 
CLASS::ExtraWidget(VDKBObjectInspector* isp) 
{ 
  inspector = isp;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);
  VDKTable* table = new VDKTable(inspector,2,2,true);

  VDKLabelButton* button = 
    new VDKLabelButton(inspector,_(wi_widget_prompts[0]));
  table->AddToCell(button,0,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&CLASS::OnSetCaption);
  caption = new VDKEntry(inspector,0,(char*) GetProp(CAPTION));
  caption->SetSize(100,-1);
  table->AddToCell(caption,0,1);
  caption->Parent(this);
  SignalConnect(caption,"activate",&CLASS::OnSetCaption);

  wrap = new VDKCheckButton(inspector,_(wi_widget_prompts[1]));
  table->AddToCell(wrap,1,0);
  wrap->Parent(this);
  SignalConnect(wrap,"toggled",&CLASS::OnSetCaptionWrap);
  
  bframe->Add(table,l_justify,false,false,false);
  return bframe; 
}
//////////////////////////////////////////////////////
// These response methods actually change both 
// properties on widget and gui widget properties
//////////////////////////////////////////////////////
/*
 */
bool
CLASS::OnSetCaptionWrap(VDKObject*)
{
  SetPropValue(CAPTIONWRAP, wrap->Checked ? CHECK_TRUE : CHECK_FALSE);
  CaptionWrap = wrap->Checked ? true : false;
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetCaption(VDKObject*)
{
  if(strlen(caption->Text)>0)
    {
      sprintf(buff,"%s",(char*) caption->Text);
      SetPropValue(CAPTION,buff);
      Caption = caption->Text;
      inspector->FormNeedToBeChanged();
    }
  return true;
}








