/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0
 * November 2001
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdk/vdktreeview.h>
#include <vdk/colors.h>
#include <string.h>
#include <stdlib.h>
static void col_clicked_cb (GtkTreeViewColumn *col, gpointer data);
/*
static void toggled_callback (GtkCellRendererToggle *celltoggle,
			      gchar                 *path_string,
			      gpointer              *tree);
*/
static void selection_cb (GtkTreeSelection *selection, gpointer *gp);
static void row_activated_cb (GtkTreeView *tree_view, GtkTreePath *path, GtkTreeViewColumn *column,gpointer *gp);
/*
 */
VDKTreeViewModel::VDKTreeViewModel( GType* types, int ncol)
{
  model = gtk_tree_store_newv (ncol,types);
}
/*
 */
GtkTreeIter*
VDKTreeViewModel::AppendBlank(GtkTreeIter* parent = NULL)
{
  gtk_tree_store_append (GTK_TREE_STORE (model), &iter, parent);
  return &iter;
}
/*
 */
GtkTreeIter*
VDKTreeViewModel::PrependBlank(GtkTreeIter* parent = NULL)
{
  gtk_tree_store_prepend (GTK_TREE_STORE (model), &iter, parent);
  return &iter;
}
/*
 */
GtkTreeIter*
VDKTreeViewModel::InsertTuple(VDKTreeViewModelTuple &tuple, GtkTreeIter* parent, bool recurse)
{
  int t = 0;
  VDKTreeViewModelIterator ti(this,parent);
  for(;ti;ti++)
    {
      VDKTreeViewModelTuple visited_tuple;  
      GetTuple(ti.current(),visited_tuple);
      // sets key index and compare function in visited tuple
      int key_index = tuple.KeyIndex;
      VDKStringCompareFunction less = tuple.Less;
      VDKStringCompareFunction equal = tuple.Equal;
      visited_tuple.KeyIndex = key_index;
      visited_tuple.Less = less;
      visited_tuple.Equal = equal;
      // insert before greater node
      if(tuple < visited_tuple)
        {
          gtk_tree_store_insert_before (GTK_TREE_STORE(GtkModel()),
                                             &iter,
                                             NULL,
                                             ti.current());
          for(t = 0; t < tuple.size(); t++)
              SetCell(&iter,t,(char*) tuple[t]); 
          return & iter;
        }
      else if(recurse && ti.HasChild())
	return InsertTuple(tuple, ti.current(),recurse);
    }
  // append to last node
  iter = *AppendBlank(parent);
  for(t = 0; t < tuple.size(); t++)
      SetCell(&iter,t,(char*) tuple[t]); 
  return &iter;
}

/*
 */
void
VDKTreeViewModel::Remove(GtkTreeIter* i)
{
  iter = *i;
  gtk_tree_store_remove (GTK_TREE_STORE (model), &iter);
  return ;
}
/*
 */
void
VDKTreeViewModel::Clear()
{
  gtk_tree_store_clear(GTK_TREE_STORE (model));
}
/*
 */
void
VDKTreeViewModel::SetData(GtkTreeIter* node,...)
{
  va_list ap;
  va_start(ap,node);
  gtk_tree_store_set_valist(GTK_TREE_STORE(model),node,ap);
  va_end(ap);
}
/*
 */
VDKTreeViewModel::~VDKTreeViewModel()
{
}

/*
 */
GtkTreeIter*
VDKTreeViewModel::Root()
{
  return gtk_tree_model_get_iter_root(GTK_TREE_MODEL(model),&iter) ? &iter : NULL;
}
/*
 */
GtkTreeIter*
VDKTreeViewModel::Next()
{
  return gtk_tree_model_iter_next(GTK_TREE_MODEL(model), &iter) ? &iter : NULL;
}

GtkTreeIter* 
VDKTreeViewModel::Child(GtkTreeIter* parent)
{
  return gtk_tree_model_iter_children (GTK_TREE_MODEL(model), &iter, parent) ? &iter : NULL;
}

/*
  local buffer should be freed by caller if not NULL.
 */

char *
VDKTreeViewModel::GetCell(GtkTreeIter* node, int column)
{
  const char* buff;
  char* local = NULL;
  GValue value = {0, };
  gtk_tree_model_get_value (GTK_TREE_MODEL(model), node, column, &value);
  GType type = gtk_tree_model_get_column_type  (GTK_TREE_MODEL(model), column);
  switch(type)
    {
    case G_TYPE_CHAR:
      {
	char val =  g_value_get_char(&value);
	local = new char[2];
	local[0] = val;
	local[1] = '\0';
      }
      break;
    case G_TYPE_STRING:
      if ( (buff = g_value_get_string (&value)) )
	{
	  local = new char[strlen(buff)+1];
	  strcpy(local,buff);
	} 
      break;
    case G_TYPE_BOOLEAN:
      {
	bool val = g_value_get_boolean (&value);
	local = new char[8];
	sprintf(local,"%s",val ? "1" : "0");
      }
      break;
    case G_TYPE_INT:
      {
	int val = g_value_get_int(&value);
	local = new char[32];
	sprintf(local,"%d",val);
      }
      break;
    case G_TYPE_UINT:
      {
	unsigned int val = g_value_get_uint(&value);
	local = new char[32];
	sprintf(local,"%u",val);
      }
      break;
    case G_TYPE_LONG:
      {
	long val = g_value_get_long(&value);
	local = new char[32];
	sprintf(local,"%ld",val);
      }
      break;
    case G_TYPE_ULONG:
      {
	unsigned long val = g_value_get_ulong(&value);
	local = new char[32];
	sprintf(local,"%lu",val);
      }
      break;
    case G_TYPE_FLOAT:
      {
	float val = g_value_get_ulong(&value);
	local = new char[64];
	sprintf(local,"%f",val);
      }
      break;
    case G_TYPE_DOUBLE:
      {
	double val = g_value_get_double(&value);
	local = new char[64];
	sprintf(local,"%f",val);
      }
      break;
    case G_TYPE_POINTER:
      {
	void* val = g_value_get_pointer(&value);
	local = new char[16];
	sprintf(local,"%p",val);
      }
    default:
      ;
    }
  g_value_unset (&value);
  return local;
}

/*
 */
void
VDKTreeViewModel::SetCell(GtkTreeIter* node, int column, const char* val)
{
  GValue value  = {0, };
  GType type = gtk_tree_model_get_column_type  (GTK_TREE_MODEL(model), column);
  g_value_init(&value,type);
  switch(type)
    {
    case G_TYPE_CHAR:
      g_value_set_char (&value,val[0]);
      break;
    case G_TYPE_STRING:
      g_value_set_string (&value,val);
      break;
    case G_TYPE_BOOLEAN:
      if(!strcasecmp("true",val))
	g_value_set_boolean (&value, 1);
      else if(!strcasecmp("false",val))
	g_value_set_boolean (&value, 0);
      else
	g_value_set_boolean (&value, atoi(val));
      break;
    case G_TYPE_INT:
      g_value_set_int (&value, atoi(val));
      break;
    case G_TYPE_UINT:
      {
	unsigned int v = (unsigned int) atoi(val);
	g_value_set_uint (&value, v);
      }
      break;
    case G_TYPE_LONG:
      g_value_set_long (&value, atol(val));
      break;
    case G_TYPE_ULONG:
      {
	unsigned long v = (unsigned long) atol(val);
	g_value_set_ulong (&value, v);
      }
      break;
    case G_TYPE_FLOAT:
      g_value_set_float (&value, atof(val));
      break;
    case G_TYPE_DOUBLE:
      {
	char * endptr;
	double v = strtod(val,&endptr);
	g_value_set_double (&value, v);
      }
      break;
    default:
        g_value_unset (&value);
	return;
    }
  gtk_tree_store_set_value (GTK_TREE_STORE(model),node,column,&value);
  g_value_unset (&value);
}

/*
  linear search on tree (depth first)
*/
struct FIND_INFO
  {
    char* value;
    GtkTreeIter* iter;
    int column;
    VDKTreeViewModel* vdkmodel;
} find_info;


static 
gboolean fetch_iter  (GtkTreeModel *model,  GtkTreePath *path,  GtkTreeIter *iter, gpointer gp)
{
  struct FIND_INFO * info = (struct FIND_INFO *) gp;// reinterpret_cast<find_info*>(gp);
  char* value = info->vdkmodel->GetCell(iter,info->column);
  if(value && !strcmp(value,info->value))
    {
      info->iter = iter;
      delete[] value;
      return TRUE;
    }
  else
    return FALSE;
}

bool
VDKTreeViewModel::Find(GtkTreeIter* iter,int column, char* value)
{
  struct FIND_INFO info;
  info.value = value;
  info.iter = NULL;
  info.column = column;
  info.vdkmodel = this;
  gtk_tree_model_foreach (GTK_TREE_MODEL(model),fetch_iter, (gpointer) &info);
  if(info.iter)
    {
      *iter = *info.iter;
      return true;
    }
  else
    return false;
}


/*
 */
void
VDKTreeViewModel::GetTuple(GtkTreeIter* node,VDKTreeViewModelTuple& tuple)
{
  int t;
  char* local;
  int n_columns = gtk_tree_model_get_n_columns (GTK_TREE_MODEL(model));
  tuple.resize(n_columns);
  for(t = 0; t < n_columns; t++)
    {
      local = GetCell(node,t);
      if(local)
	{
	  tuple[t] = local;
	  delete[] local;
	}
    }
  return ;
}


/*
                 VDK_TREE_VIEW_ITERAROR
*/
/*
 */
VDKTreeViewModelIterator::VDKTreeViewModelIterator(VDKTreeViewModel* model,GtkTreeIter* parent):
  model(model)
{
  if(parent)
    {
      if(gtk_tree_model_iter_children (GTK_TREE_MODEL(model->GtkModel()), &iter, parent))
	internal_iter = &iter;
      else
	internal_iter = NULL;
    }  
  else if(gtk_tree_model_get_iter_root(GTK_TREE_MODEL(model->GtkModel()) ,&iter))
    internal_iter = &iter;
  else
    internal_iter = NULL;
       
}


void
VDKTreeViewModelIterator::operator++()
{
  if(gtk_tree_model_iter_next(GTK_TREE_MODEL(model->GtkModel()), &iter))
    internal_iter = &iter;
  else
    internal_iter = NULL;
}

void
VDKTreeViewModelIterator::operator++(int)
{
  if(gtk_tree_model_iter_next(GTK_TREE_MODEL(model->GtkModel()), &iter))
    internal_iter = &iter;
  else
    internal_iter = NULL;
}

bool
VDKTreeViewModelIterator::HasChild()
{
  if(internal_iter)
    {
      if(gtk_tree_model_iter_has_child (GTK_TREE_MODEL(model->GtkModel()), &iter))
	return true;
    }
  return false;
}


/*

                  VDKTREEVIEWCOLUMN
 */

void
VDKTreeViewColumn::edited_callback (GtkCellRendererText *cell,
	gchar               *path_string,
	gchar               *new_text,
	gpointer             data)
{
  VDKTreeViewColumn* column = reinterpret_cast<VDKTreeViewColumn*>(data);
  VDKTreeView* tree = column->Owner();
  VDKTreeViewModel *model = tree->Model;
#ifdef USE_SIGCPLUSPLUS
  {
    int t = 0;
    GtkTreeIter iter;
    GtkTreePath *path = gtk_tree_path_new_from_string (path_string);
    gtk_tree_model_get_iter (GTK_TREE_MODEL(model->GtkModel()), &iter, path);
    VDKTreeViewColumnListIterator li(*tree->Columns());
    for(;li;li++,t++)
      if(column == li.current())
	break;
    t = t < tree->Columns()->size() ? t : -1;
    tree->OnCellEdited(tree,&iter,t,new_text);
    gtk_tree_path_free (path);
  }
#endif 
}
/*
 */
void
VDKTreeViewColumn::toggled_callback (GtkCellRendererToggle *cell,
	 gchar                 *path_string,
	 gpointer               data)
{
  VDKTreeViewColumn* column = reinterpret_cast<VDKTreeViewColumn*>(data);
  VDKTreeView* tree = column->Owner();
  VDKTreeViewModel *model = tree->Model;
#ifdef USE_SIGCPLUSPLUS
  {
    int t = 0;
    GtkTreeIter iter;
    gboolean value;
    GtkTreePath *path = gtk_tree_path_new_from_string (path_string);
    gtk_tree_model_get_iter (GTK_TREE_MODEL(model->GtkModel()), &iter, path);
    VDKTreeViewColumnListIterator li(*tree->Columns());
    for(;li;li++,t++)
      if(column == li.current())
	break;
    t = t < tree->Columns()->size() ? t : -1;
    if(t>=0)
      {
       gtk_tree_model_get (GTK_TREE_MODEL(model->GtkModel()), &iter, t, &value, -1);
       tree->OnCellToggled(tree,&iter,t,value);
       gtk_tree_path_free (path);
      }
    
  }
#endif
}
/*
 */
VDKTreeViewColumn::VDKTreeViewColumn(VDKTreeView *owner, int col, char* title, bool editable, int ecol):
  owner(owner), handler_seq_no(0),
  NormalBackground("NormalBackground",this,VDKRgb(-1,-1,-1),
		   &VDKTreeViewColumn::SetNormalBackground),
  Foreground("Foreground",this,VDKRgb(-1,-1,-1),
	     &VDKTreeViewColumn::SetForeground),
  Title("Title",this,NULL,&VDKTreeViewColumn::SetTitle,&VDKTreeViewColumn::GetTitle),
  Width("Width",this,0,&VDKTreeViewColumn::SetWidth,&VDKTreeViewColumn::GetWidth),
  Sortable("Sortable",this,false,&VDKTreeViewColumn::SetSortable)
{
  VDKTreeViewModel* model = owner->Model;
  // error if no model ..... and/or editable stuff
  GType type = gtk_tree_model_get_column_type  (GTK_TREE_MODEL(model->GtkModel()), col);
  if( type == GDK_TYPE_PIXBUF)
    {
      cell = gtk_cell_renderer_pixbuf_new ();
      column = gtk_tree_view_column_new_with_attributes (title,cell,"pixbuf",col, NULL);
    }
  else
    {
      switch(type)
	{
	case G_TYPE_STRING:
	  cell = gtk_cell_renderer_text_new ();
	  if(!editable)
	    column = gtk_tree_view_column_new_with_attributes (title,cell,"text",col,NULL); 
	  else 
	    {
	    column = gtk_tree_view_column_new_with_attributes (title,cell,
							       "text",col,
							       "editable",ecol >= 0 ? ecol : 0,
							       NULL); 
	    g_signal_connect_data (G_OBJECT (cell), "edited",
		  G_CALLBACK (VDKTreeViewColumn::edited_callback), this, NULL,(GConnectFlags) 0);
	    }
	  break;
	  
	case G_TYPE_BOOLEAN:
	  cell = gtk_cell_renderer_toggle_new ();
	  /* 
	  g_object_set (G_OBJECT (cell),"activatable", TRUE, "radio", FALSE, NULL);

	  */
	  column = gtk_tree_view_column_new_with_attributes (title,cell, "active", col,NULL);
	  g_signal_connect_data (G_OBJECT (cell), "toggled",
		  G_CALLBACK (VDKTreeViewColumn::toggled_callback), this, NULL,(GConnectFlags) 0);

	  break;
	default:
	  column = NULL; // ERROR
	}
    }


  if(column)
    {
      if(title)
	Title = title;
      SetWidth(0);
      owner->Columns()->add(this);
      gtk_tree_view_append_column (GTK_TREE_VIEW (owner->WrappedWidget()), GTK_TREE_VIEW_COLUMN (column));      
    }
}


/*
 */
VDKTreeViewColumn::~VDKTreeViewColumn()
{
}

/*
 */
void 
VDKTreeViewColumn::ActiveTitle(bool flag)
{
  gtk_tree_view_column_set_clickable (GtkColumn(), flag);
  if(flag && (handler_seq_no == (gulong) 0))
    handler_seq_no = g_signal_connect_data (G_OBJECT (GtkColumn()), "clicked",  
			 (GCallback) ::col_clicked_cb, owner ,NULL,(GConnectFlags) 0);    
}
/*
 */
void 
VDKTreeViewColumn::SetNormalBackground(VDKRgb rgb)
{
    VDKColor *color = NULL;
    color = new VDKColor( owner->Owner() ,rgb.red, rgb.green, rgb.blue);
    g_object_set (G_OBJECT (cell),"background-gdk", color->Color(),NULL);
}
/*
 */
void 
VDKTreeViewColumn::SetForeground(VDKRgb rgb)
{
   VDKColor *color = NULL;
   color = new VDKColor( owner->Owner() ,rgb.red, rgb.green, rgb.blue);
   g_object_set (G_OBJECT (cell),"foreground-gdk", color->Color(),NULL);
}
   
/*
 */
void 
VDKTreeViewColumn::SetFont(VDKFont* font)
{
  g_object_set (G_OBJECT (cell),"font-desc", font->AsPangoFontDescription(),NULL);
}
/*
 */
void 
VDKTreeViewColumn::SetTitle(const char* title)
{
  gtk_tree_view_column_set_title  (GTK_TREE_VIEW_COLUMN (column),title);
}
/*
 */
const char*
VDKTreeViewColumn::GetTitle()
{
  return gtk_tree_view_column_get_title  (GTK_TREE_VIEW_COLUMN (column));
}
/*
 */
void 
VDKTreeViewColumn::SetWidth(int w)
{
  if(w > 0)
    {
      gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column), GTK_TREE_VIEW_COLUMN_FIXED);
      gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column),w);
    }
  else
    gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column), GTK_TREE_VIEW_COLUMN_AUTOSIZE);   
}
/*
 */
int
VDKTreeViewColumn::GetWidth()
{
  return gtk_tree_view_column_get_width (GTK_TREE_VIEW_COLUMN (column));
}

/*
 */
void 
VDKTreeViewColumn::SetSortable(bool flag )
{
  int t = 0;
  if(flag)
    {
      VDKTreeViewColumnListIterator li(*owner->Columns());
      for(;li;li++,t++)
	if(this == li.current())
	  gtk_tree_view_column_set_sort_column_id (GtkColumn(),t);
    }
  else
    gtk_tree_view_column_set_sort_column_id (GtkColumn(),-1);
}

/*


                       VDKTREEVIEW CLASS


 */
void
col_clicked_cb (GtkTreeViewColumn *col, gpointer gp)
{
  VDKTreeView * tree = reinterpret_cast<VDKTreeView*>(gp);
  VDKTreeViewColumnListIterator li(*(tree->Columns()));
  int t = 0;
  for(;li;li++,t++)
    {
      if(li.current()->GtkColumn() == col)
	{
	  tree->SelectedColumn(t);
	  tree->SignalEmit(click_column_signal);
	  tree->SignalEmit("click_column_signal");
	  return;
	}
    }
  tree->SelectedColumn(-1);
}
/*
 */
/*
void 
toggled_callback (GtkCellRendererToggle *celltoggle,
			      gchar                 *path_string,
			      gpointer              *tree)
{
  printf("\ncelltoggle:%p, %s, gpointer:%p",celltoggle,path_string,tree);
  fflush(stdout);
  return;
}
*/
void
selection_cb (GtkTreeSelection *selection,
	      gpointer     *gp)
{
  VDKTreeView* tree = reinterpret_cast<VDKTreeView*>(gp);
  VDKTreeViewIter iter;
  tree->Selections().flush();
  if (!gtk_tree_selection_get_selected (selection, NULL,&iter))
    return;
  else
    {
      tree->Selections().add(iter);
      tree->SignalEmit(select_row_signal);
      tree->SignalEmit("select_row_signal");
    }
}


static 
void visit_selection  (GtkTreeModel *model,  GtkTreePath *path,  GtkTreeIter *iter, gpointer gp)
{
  VDKTreeViewIter i;
  VDKTreeView* tree = reinterpret_cast<VDKTreeView*>(gp);
  //  gtk_tree_model_get_iter (model, &i, path);  
  /*
    uhmmm...
    using GtkTreeIter private data could not be a good idea on compatibility side,
    in  other hand i suspect a O(n2) time using gtk_tree_model_get_iter()
  */
  i.stamp = iter->stamp;
  i.user_data = iter->user_data;
  i.user_data2 = iter->user_data2;
  i.user_data3 = iter->user_data3;

  tree->Selections().add(i);
}


void
row_activated_cb (GtkTreeView *tree_view,
		  GtkTreePath *path,
		  GtkTreeViewColumn *column,
		  gpointer  *gp)
{
  VDKTreeView* tree = reinterpret_cast<VDKTreeView*>(gp);
  tree->SignalEmit(row_activated_signal);
  tree->SignalEmit("row_activated_signal");
}

void
VDKTreeView::GetSelections()
{
  Selections().flush();
  gtk_tree_selection_selected_foreach(selection, visit_selection, this);
}

/*
 */
VDKTreeView::VDKTreeView(VDKForm* owner, VDKTreeViewModel* model, GtkSelectionMode mode):
  VDKObject(owner),
  Model("Model",this,NULL,&VDKTreeView::SetModel,NULL),
  SelectedColumn("SelectedColumn",this,-1)

{
  if(model)
    {
      widget = sigwid = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model->GtkModel())); 
      Model(model);
    }
   else
       widget = sigwid = gtk_tree_view_new ();
  ConnectDefaultSignals();
  gtk_tree_selection_set_mode (GTK_TREE_SELECTION (gtk_tree_view_get_selection (GTK_TREE_VIEW (sigwid))),mode);
  // 
  columns = new VDKTreeViewColumnList;
  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (sigwid));
  switch(mode)
    {
    case GTK_SELECTION_SINGLE:
    case GTK_SELECTION_BROWSE:
      g_signal_connect_data(selection, "changed", G_CALLBACK (selection_cb), this, NULL,(GConnectFlags) 0);
      g_signal_connect_data (sigwid, "row_activated", G_CALLBACK (row_activated_cb), this, NULL,(GConnectFlags) 0);
      break;
    case GTK_SELECTION_MULTIPLE:
      g_signal_connect_data (sigwid, "row_activated", G_CALLBACK (row_activated_cb), this, NULL,(GConnectFlags) 0);
      break;
    }

}
/*
 */
VDKTreeView::~VDKTreeView()
{
  VDKTreeViewModel *model = Model;
  if(model)
    delete model;
  delete columns;
}

/*
 */
void 
VDKTreeView::SetModel(VDKTreeViewModel* mod)
{
  VDKTreeViewModel *old = Model;
  gtk_tree_view_set_model (GTK_TREE_VIEW(widget),GTK_TREE_MODEL (mod->GtkModel()));
  if(old)
    {
      delete old;
    }
}

/*
 */
void 
VDKTreeView::SelectNode(GtkTreeIter* iter)
{
  if(iter)
    gtk_tree_selection_select_iter  (selection,iter);
}
/*
 */
void 
VDKTreeView::UnselectNode(GtkTreeIter* iter)
{
  if(iter)
    gtk_tree_selection_unselect_iter  (selection,iter);
}
/*
 */
void 
VDKTreeView::Expand(GtkTreeIter* iter, bool expand_all)
{
  if(!iter)
    gtk_tree_view_expand_all(GTK_TREE_VIEW(sigwid));
  else
    {
      VDKTreeViewModel *model = Model;
      GtkTreePath* path = gtk_tree_model_get_path (GTK_TREE_MODEL(model->GtkModel()),iter);
      if(path)
	{
	  gtk_tree_view_expand_row (GTK_TREE_VIEW(sigwid),path,expand_all);
	  gtk_tree_path_free(path); 
	}
    }
}
/*
 */
void 
VDKTreeView::RemoveSelected(void)
{
  GetSelections();
  VDKTreeViewModel* model = Model;
  VDKTreeViewIterListIterator li(Selections());
  for(li.last();li;li--)
    model->Remove(&li.current());
  Selections().flush();
}
