/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.6
 * Revision 3
 * July 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "vdk/vdkpacker.h"
#include "vdk/forms.h"

VDKPacker::VDKPacker(VDKForm* owner)
  :VDKObjectContainer(owner),
   Spacing("Spacing",this,0,&VDKPacker::SetSpacing),
   Padding("Spacing",this,VDKPoint(0,0),&VDKPacker::SetPadding)
{
widget = gtk_packer_new();
}

VDKPacker::~VDKPacker()
{
}

void 
VDKPacker::Add(VDKObject* obj, 
		    int side,
		    int anchor, 
		    int options,
		    int borderwidth)
{
   gtk_packer_add (GTK_PACKER(widget), 
		   obj->Widget(),
		   (GtkSideType) side,
		   (GtkAnchorType) anchor,
		   (GtkPackerOptions) options,
		   borderwidth, 
		   0, // pad_x, 
		   0, // pad_y,
		   0, // i_pad_x,
		   0 // i_pad_y
		   );
  // calls ancestor (B.Liskov docet...)
  VDKObjectContainer::Add(obj,0,0,0,0);
}


void 
VDKPacker::ReconfigureChild(VDKObject* obj, 
		   int side,
		   int anchor, 
		   int options,
		   int borderwidth)
{
  gtk_packer_set_child_packing (GTK_PACKER(widget), 
				obj->Widget(),
				(GtkSideType) side,
				(GtkAnchorType) anchor,
				(GtkPackerOptions) options,
				borderwidth, 
				0, // pad_x, 
				0, // pad_y,
				0, // i_pad_x,
				0 // i_pad_y
				);
}


  
