/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef NOTEBOOK_H
#define NOTEBOOK_H
#include <vdk/widcontain.h>
#include <vdk/dlist.h>
#include <vdk/vdkprops.h>
extern char *book_open_xpm[];
extern char *book_closed_xpm[];

class VDKPixmap;
class VDKLabel;
class VDKBox;
class VDKForm;
class VDKNotebook;
class PageList;
class VDKTabPage;
typedef VDKList<VDKTabPage> PList;
typedef VDKListiterator<VDKTabPage> PListIterator;

/*
*/
typedef VDKReadWriteValueProp<VDKNotebook,int> NoteBookIntProp;

class ActivePageProperty: public NoteBookIntProp
{

public:
  ActivePageProperty();
  ActivePageProperty(
		     char* name,
		     VDKNotebook* object,
		     void (VDKNotebook::*write)(int) = NULL,
		     int (VDKNotebook::*read)(void) = NULL
		     );
  virtual ~ActivePageProperty();
  operator int();
  void operator=(int page);
  void operator++();
  void operator--();
  void operator++(int);
  void operator--(int);
};

/*
 */
class NotebookTabPosProperty: public NoteBookIntProp
{

public:
  NotebookTabPosProperty();
  NotebookTabPosProperty(
			 char* name,
			 VDKNotebook* object,
			 void (VDKNotebook::*write)(int) = NULL,
			 int (VDKNotebook::*read)(void) = NULL
			 );
  virtual ~NotebookTabPosProperty();
  void operator = (int pos);
};
/*!
  \class VDKTabpage
  \brief This class represents a single page of a notebook widget
 */
class VDKTabPage
{
  
  GtkWidget /**label_wid,*/*tab;
  GdkPixmap *open;
  GdkPixmap *closed;
  GdkBitmap *open_mask;
  GdkBitmap *closed_mask;
  friend class PageList;
  friend class VDKNotebook;
  VDKObject* child;
  VDKObject* book;
 public:
 
  // properties
  /*!
    Access to page label
   */
  VDKLabel*  TabLabel; // the tab label
  /*!
    \internal
   */
  VDKTabPage(VDKObject* owner,
	     VDKObject* child,
	     char *label,
	     char **pixmap_closed,
	     char **pixmap_open);
  virtual ~VDKTabPage() {}
};
/*!
  \class PageList
  \brief Pages list of a notebook
 */
class PageList: PList
{
  friend class VDKNotebook;
  VDKNotebook *book;
 public:
  /*!
    \internal
   */
  PageList(VDKNotebook* book = NULL): PList(), book(book) {}
  ~PageList();
  /*!
    \internal
   */
  void AddPage(VDKObject* child,
	       char *label,
	       char **pixmap_closed,
	       char **pixmap_open);
  /*!
    Access to a single page
    \param n index number (0 <= n < size)
   */
  VDKTabPage* operator[](int n);
  /*!
    Return how many pages there are into notebook
   */
  int size() { return PList::size() ; }
};
/*!
  \class VDKNotebook
  \brief Provides a notebook widget
  \par SIGNALS
  \arg \b switch_page_signal received whenever user switches between
  notebook pages.
  \par TIP
  Add the notebook to the parent container before adding pages.
  \par EXAMPLES
  In ./testvdk/nbookwin.cc
 */
class VDKNotebook: public VDKObjectContainer 
{
  static void PageSwitch(GtkWidget *widget, 
				      GtkNotebookPage *page,
				      int pagenum,
				      gpointer gp);
 protected:

public:
  // properties
  /*!
    Return a list of notebook pages
    You can access to a single page like this:
    \code
    // disables last page
    book->Pages[book->Pages.size()-1]->TabLabel->Enabled = false;
    \endcode
    (run-time read only)
   */
  PageList Pages; // run-time read only
  /*!
    Sets/gets currently active page
    \par TIP
    This property has also increment/decrement operator
    \code
    book->ActivePage++;
    book->ActivePage--;
    \endcode
   */
  ActivePageProperty ActivePage;
  /*!
    Sets/gets notebook tabs position
   */
  NotebookTabPosProperty TabPosition;
  /*!
    Sets/gets notebook scrollable flags
   */
  VDKReadWriteValueProp<VDKNotebook,bool> Scrollable;
  /*!
    Setting to true enables pop menu on notebook
   */
  VDKReadWriteValueProp<VDKNotebook,bool> PopUp;
  /*!
    Gets previous active page
   */
  VDKReadOnlyValueProp<VDKNotebook,int> PreviousActivePage;
  //
  /*!
    Constructor
    \param owner
   */
  VDKNotebook(VDKForm* owner = NULL);
  /*!
    Destructor
  */
  virtual ~VDKNotebook();
  /*!
    Add a page containing <obj>
    \param obj
    \param others unused
   */
  void Add(VDKObject* obj, int , int , int , int )
      { AddPage(obj,""); }
  /*!
    Add a page containing <obj>
    \param obj widget to be added (normally a container)
    \param label tab label
    \param pixmap_closed
    \param pixmap_open

    \par TIP
    Tabs can show two different pixmaps, opened (when page
    is selected) or closed (when unselected)
   */
  void AddPage(VDKObject* obj,
	       char *label,
	       char **pixmap_closed = NULL,
	       char **pixmap_open = NULL);
  /*!
    Remove a page from notebook
    \param page page to be removed
    \param removechild if false page child won't be removed
    \par Tip
    Normal user doesn't care about <removechild> arg
    and let it be <true> as default.
    Used to better support VDKBuilder notebook handling.
   */
  void RemovePage(int page, bool removechild = true);
  bool GetScrollable()
    { return Scrollable; }
  void SetScrollable(bool flag)
    { 
      gtk_notebook_set_show_tabs (GTK_NOTEBOOK(widget), flag);
      gtk_notebook_set_scrollable (GTK_NOTEBOOK(widget), flag);
    }
  bool GetPopUp()
    { return PopUp; }
  void SetPopUp(bool flag)
    { 
      if (flag)
	gtk_notebook_popup_enable (GTK_NOTEBOOK(widget));
      else
	gtk_notebook_popup_disable (GTK_NOTEBOOK(widget));
    }
  int GetPreviousActivePage()
    { return gtk_notebook_current_page(GTK_NOTEBOOK(widget)); }
#ifdef USE_SIGCPLUSPLUS
  VDKSignal1<void,int> OnPageSwitch;
#endif // USE_SIGCPLUSPLUS
};
#endif


