//**************************************************************************
//**
//**	##   ##    ##    ##   ##   ####     ####   ###     ###
//**	##   ##  ##  ##  ##   ##  ##  ##   ##  ##  ####   ####
//**	 ## ##  ##    ##  ## ##  ##    ## ##    ## ## ## ## ##
//**	 ## ##  ########  ## ##  ##    ## ##    ## ##  ###  ##
//**	  ###   ##    ##   ###    ##  ##   ##  ##  ##       ##
//**	   #    ##    ##    #      ####     ####   ##       ##
//**
//**	$Id: matrix.h 4279 2010-05-28 17:13:12Z dj_jl $
//**
//**	Copyright (C) 1999-2010 Jānis Legzdiņš
//**
//**	This program is free software; you can redistribute it and/or
//**  modify it under the terms of the GNU General Public License
//**  as published by the Free Software Foundation; either version 2
//**  of the License, or (at your option) any later version.
//**
//**	This program is distributed in the hope that it will be useful,
//**  but WITHOUT ANY WARRANTY; without even the implied warranty of
//**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//**  GNU General Public License for more details.
//**
//**************************************************************************

class VMatrix4
{
public:
	float		m[4][4];

	static const VMatrix4	Identity;

	VMatrix4()
	{}
	VMatrix4(float m00, float m01, float m02, float m03,
		float m10, float m11, float m12, float m13,
		float m20, float m21, float m22, float m23,
		float m30, float m31, float m32, float m33);
	VMatrix4(float* m2);
	float Determinant() const;
	VMatrix4 Inverse() const;
	VMatrix4 Transpose() const;
	TVec Transform(const TVec& V) const;
	TVec Transform2(const TVec& V) const;

	float* operator[] (int i)
	{
		return m[i];
	}
	const float* operator[] (int i) const
	{
		return m[i];
	}

	friend VMatrix4 operator * (const VMatrix4& M1, const VMatrix4& M2);
};
