/* valatypeparametertype.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALATYPEPARAMETERTYPE_H__
#define __VALA_VALATYPEPARAMETERTYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadatatype.h>
#include <vala/valatypeparameter.h>

G_BEGIN_DECLS


#define VALA_TYPE_TYPEPARAMETER_TYPE (vala_typeparameter_type_get_type ())
#define VALA_TYPEPARAMETER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER_TYPE, ValaTypeParameterType))
#define VALA_TYPEPARAMETER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER_TYPE, ValaTypeParameterTypeClass))
#define VALA_IS_TYPEPARAMETER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER_TYPE))
#define VALA_IS_TYPEPARAMETER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER_TYPE))
#define VALA_TYPEPARAMETER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER_TYPE, ValaTypeParameterTypeClass))

typedef struct _ValaTypeParameterType ValaTypeParameterType;
typedef struct _ValaTypeParameterTypeClass ValaTypeParameterTypeClass;
typedef struct _ValaTypeParameterTypePrivate ValaTypeParameterTypePrivate;

/**
 * The type of a generic type parameter.
 */
struct _ValaTypeParameterType {
	ValaDataType parent_instance;
	ValaTypeParameterTypePrivate * priv;
};

struct _ValaTypeParameterTypeClass {
	ValaDataTypeClass parent_class;
};


ValaTypeParameterType* vala_typeparameter_type_new (ValaTypeParameter* type_parameter);
GType vala_typeparameter_type_get_type (void);


G_END_DECLS

#endif
