import ast

def literal_dict(value):
    """
    If the value is a string, this converts it to a dict via
    the ``ast.literal_eval`` method. If the value is a dict,
    the value is returned. If the value is any other type,
    then a ``ValueError`` is raised.
    """
    if isinstance(value, str):
        value = ast.literal_eval(value)

    if not isinstance(value, dict):
        raise ValueError, "Value is not a valid dict."

    return value
