/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISU_OBJECT_H
#define VISU_OBJECT_H

/* This .c and .h is here to create a GObject
   that can emit signals when necessary. */

#include <glib-object.h>

#include <stdlib.h>
#include <string.h>
#include "visu_tools.h"
#include "visu_rendering.h"

G_BEGIN_DECLS

/**
 * VISU_TYPE:
 *
 * return the type of #VisuObject.
 */
#define VISU_TYPE		  (visuObject_get_type ())
/**
 * VISU:
 * @obj: a #GObject to cast.
 *
 * Cast the given @obj into #VisuObject type.
 */
#define VISU(obj)		  (G_TYPE_CHECK_INSTANCE_CAST ((obj), VISU_TYPE, VisuObject))
/**
 * VISU_CLASS:
 * @klass: a #GObjectClass to cast.
 *
 * Cast the given @klass into #VisuObjectClass.
 */
#define VISU_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), VISU_TYPE, VisuObjectClass))
/**
 * IS_VISU_TYPE:
 * @obj: a #GObject to test.
 *
 * Test if the given @ogj is of the type of #VisuObject object.
 */
#define IS_VISU_TYPE(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VISU_TYPE))
/**
 * IS_VISU_CLASS:
 * @klass: a #GObjectClass to test.
 *
 * Test if the given @klass is of the type of #VisuObjectClass class.
 */
#define IS_VISU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VISU_TYPE))
/**
 * VISU_GET_CLASS:
 * @obj: a #GObject to get the class of.
 *
 * It returns the class of the given @obj.
 */
#define VISU_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), VISU_TYPE, VisuObjectClass))

/**
 * VisuObject:
 *
 * A short way to identify #_VisuObject structure.
 */
typedef struct _VisuObject VisuObject;

enum
  {
    COLORNEWAVAILABLE_SIGNAL,
    DATANEW_SIGNAL,
    DATALOADED_SIGNAL,
    DATAREADYFORRENDERING_SIGNAL,
    RENDERINGCHANGED_SIGNAL,
    RESOURCESLOADED_SIGNAL,
    OPENGLASKFORREDRAW_SIGNAL,
    OPENGLFORCEREDRAW_SIGNAL,
    DIR_SIGNAL,
    VISU_NB_SIGNAL
  };

/**
 * VisuObjectClass:
 * @parent: an object to inherit from (NULL here).
 * @signals: the array with the signals.
 *
 * This structure describes the class #VisuObjectClass.
 */
struct _VisuObjectClass
{
  GObjectClass parent;

  guint signals[VISU_NB_SIGNAL];
};
typedef struct _VisuObjectClass VisuObjectClass;

gboolean visu_object_redraw(gpointer data);
gboolean visu_object_redrawForce(gpointer data);

/**
 * VISU_ADD_REDRAW:
 *
 * A macro to ask V_Sim to redraw the rendering area at next idle
 * time, except if the deferred redraw option is set.
 */
#define VISU_ADD_REDRAW   g_idle_add(visu_object_redraw, (gpointer)__func__)
/**
 * VISU_FORCE_REDRAW:
 *
 * Force V_Sim to redraw at the next idle time, whatever value for the
 * deferred redraw option.
 */
#define VISU_FORCE_REDRAW g_idle_add(visu_object_redrawForce, (gpointer)__func__)

/**
 * visuObject_get_type:
 *
 * This method returns the type of #VisuObject, use VISU_TYPE instead.
 *
 * Returns: the type of #VisuObject.
 */
GType visuObject_get_type (void);

/**
 * VISU_INSTANCE:
 * 
 * This routine is used to get the global #VisuObject object to listen
 * to its signals.
 */
#define VISU_INSTANCE visuObjectGet_static()
VisuObject* visuObjectGet_static();

/**
 * VISU_SIGNALS:
 *
 * Get the list of signals of a #VisuObject.
 */
#define VISU_SIGNALS VISU_GET_CLASS(VISU_INSTANCE)->signals

gboolean visu_object_setRendering(VisuObject *obj, VisuRendering* method);
VisuRendering* visu_object_getRendering(VisuObject *obj);

G_END_DECLS

#endif
