/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "visu_dump.h"

#include "visu_tools.h"
#include "dumpModules/externalDumpModules.h"

/**
 * SECTION:visu_dump
 * @short_description: Some resources to add the ability to export the
 * rendered data to an other format (usually image format).
 *
 * <para>V_Sim can export loaded data to othe formats. This module
 * descibes the methods and structure to create a dumping
 * extension. Basically, a dumping extension is just a #FileFormat and
 * a method that is called when exporting is required. No method
 * exists to create a dumping extension, just allocate and initialize
 * the #DumpType structure.</para>
 *
 * <para>The #writeDumpFunc should suspend its process to allow the
 * calling program to refresh itself if the dump process is
 * slow. Ideally, the argument @waitFunction should be called exactly
 * 100 times.</para>
 */

static GQuark quark;
static GList *allDumpModuleList = (GList*)0;
static int nbDumpModules = 0;
static gboolean dumpListIsInitialized = FALSE;

static void initDumpList();

/**
 * visu_dump_getAllModules:
 *
 * All dumping extensions are stored in an opaque way in V_Sim. But
 * they can be listed by a call to this method.
 *
 * Returns: (transfer none) (element-type VisuDump*): a list of all
 * the known dumping extensions. This list is own by V_Sim and should
 * be considered read-only.
 */
GList* visu_dump_getAllModules()
{
  if (!dumpListIsInitialized)
    initDumpList();
  DBG_fprintf(stderr, "Visu Dump: give list of dumps (%p).\n",
	      (gpointer)allDumpModuleList);
  return allDumpModuleList;
}
/**
 * visu_dump_getNModules:
 * 
 * A convenient way to know how many dumping extensions are registered.
 *
 * Returns: the number of known dumping extensions.
 */
gint visu_dump_getNModules()
{
  if (!dumpListIsInitialized)
    initDumpList();
  return nbDumpModules;
}

/**
 * visu_dump_callWriteFunc:
 * @dump: a #VisuDump object ;
 * @fileName: a string that defined the file to write to ;
 * @width: an integer ;
 * @height: an integer ;
 * @dataObj: the #VisuData to be exported ;
 * @image: (allow-none) (element-type gint8): the data to be written ;
 * @error: a location to store some error (not NULL) ;
 * @functionWait: (allow-none) (scope call): a method to call periodically during the dump ;
 * @data: (closure): some pointer on object to be passed to the wait
 * function.
 *
 * Use the write function of @dump to export the current @dataObj to
 * file @fileName.
 *
 * Since: 3.6
 *
 * Returns: TRUE if dump succeed.
 */
gboolean visu_dump_callWriteFunc(VisuDump *dump, const char* fileName,
				 int width, int height, VisuData *dataObj,
				 GArray* image, ToolVoidDataFunc functionWait,
				 gpointer data, GError **error)
{
  g_return_val_if_fail(dump && dump->writeFunc, FALSE);

  return dump->writeFunc(dump->fileType, fileName, width, height,
			 dataObj, (guchar*)image->data, error, functionWait, data);
}


static void initDumpList()
{
  int i;
  VisuDump *dump;

  DBG_fprintf(stderr, "Visu Dump: Init export list.\n");
  for (i = 0; listInitDumpModuleFunc[i]; i++)
    {
      dump = listInitDumpModuleFunc[i]();
      if (dump)
	{
	  DBG_fprintf(stderr, " | %s\n", tool_file_format_getLabel(dump->fileType));
	  nbDumpModules ++;
	  allDumpModuleList = g_list_append(allDumpModuleList, dump);
	}
    }
  dumpListIsInitialized = TRUE;
  DBG_fprintf(stderr, "Visu Dump: %d valid dump module(s) found.\n", nbDumpModules);

  quark = g_quark_from_static_string("visu_dump");
}
/**
 * visuDumpAdd:
 * @dump: a #VisuDump method.
 *
 * Add the provided dump method to the list of available ones.
 *
 * Since: 3.6
 */
void visuDumpAdd(VisuDump *dump)
{
  g_return_if_fail(dump);

  nbDumpModules += 1;
  allDumpModuleList = g_list_append(allDumpModuleList, dump);
}
/**
 * visu_dump_getQuark: (skip)
 * 
 * Internal routine to get the #GQuark to handle error related to dump
 * actions.
 */
GQuark visu_dump_getQuark()
{
  return quark;
}

void visuDumpAbort(GObject *obj _U_, gpointer data)
{
  /* TODO : mettre un stop dans le fichier en cours. */
  DBG_fprintf(stderr, "Visu dump : abortion requested.\n");
  *((int*)data) = 1;
}
