/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef SCALE_H
#define SCALE_H

#include <visu_tools.h>
#include <openGLFunctions/view.h>

/**
 * VISU_GLEXT_XYZ_MASK_X:
 *
 * This value can be used to create a mask for methods that
 * require one for reading xyz coordinates array. This value actually
 * correspond to the x direction.
 *
 * Since: 3.3
 */
#define VISU_GLEXT_XYZ_MASK_X (1 << 0)
/**
 * VISU_GLEXT_XYZ_MASK_Y:
 *
 * This value can be used to create a mask for methods that
 * require one for reading xyz coordinates array. This value actually
 * correspond to the y direction.
 *
 * Since: 3.3
 */
#define VISU_GLEXT_XYZ_MASK_Y (1 << 1)
/**
 * VISU_GLEXT_XYZ_MASK_Z:
 *
 * This value can be used to create a mask for methods that
 * require one for reading xyz coordinates array. This value actually
 * correspond to the z direction.
 *
 * Since: 3.3
 */
#define VISU_GLEXT_XYZ_MASK_Z (1 << 2)
/**
 * VISU_GLEXT_XYZ_MASK_ALL:
 *
 * This value can be used to create a mask for methods that
 * require one for reading xyz coordinates array. This value is a
 * shortcut for #VISU_GLEXT_XYZ_MASK_X | #VISU_GLEXT_XYZ_MASK_Y | #VISU_GLEXT_XYZ_MASK_Z.
 *
 * Since: 3.3
 */
#define VISU_GLEXT_XYZ_MASK_ALL (7)

/**
 * VISU_GLEXT_SCALE_TYPE:
 *
 * return the type of #VisuGlExtScale.
 *
 * Since: 3.3
 */
#define VISU_GLEXT_SCALE_TYPE	     (visu_glExt_scale_get_type ())
/**
 * VISU_GLEXT_SCALE:
 * @obj: a #GObject to cast.
 *
 * Cast the given @obj into #VisuGlExtScale type.
 *
 * Since: 3.3
 */
#define VISU_GLEXT_SCALE(obj)	     (G_TYPE_CHECK_INSTANCE_CAST(obj, VISU_GLEXT_SCALE_TYPE, VisuGlExtScale))
/**
 * VISU_GLEXT_SCALE_CLASS:
 * @klass: a #GObjectClass to cast.
 *
 * Cast the given @klass into #VisuGlExtScaleClass.
 *
 * Since: 3.3
 */
#define VISU_GLEXT_SCALE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST(klass, VISU_GLEXT_SCALE_TYPE, VisuGlExtScaleClass))
/**
 * VISU_GLEXT_IS_SCALE:
 * @obj: a #GObject to test.
 *
 * Test if the given @ogj is of the type of #VisuGlExtScale object.
 *
 * Since: 3.3
 */
#define VISU_GLEXT_IS_SCALE(obj)    (G_TYPE_CHECK_INSTANCE_TYPE(obj, VISU_GLEXT_SCALE_TYPE))
/**
 * VISU_GLEXT_IS_VISU_GLEXT_SCALE_CLASS:
 * @klass: a #GObjectClass to test.
 *
 * Test if the given @klass is of the type of #VisuGlExtScaleClass class.
 *
 * Since: 3.3
 */
#define VISU_GLEXT_IS_VISU_GLEXT_SCALE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE(klass, VISU_GLEXT_SCALE_TYPE))
/**
 * VISU_GLEXT_SCALE_GET_CLASS:
 * @obj: a #GObject to get the class of.
 *
 * It returns the class of the given @obj.
 *
 * Since: 3.3
 */
#define VISU_GLEXT_SCALE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(obj, VISU_GLEXT_SCALE_TYPE, VisuGlExtScaleClass))

/**
 * VisuGlExtScaleClass:
 *
 * An opaque structure.
 *
 * Since: 3.3
 */
typedef struct _VisuGlExtScaleClass VisuGlExtScaleClass;

/**
 * VisuGlExtScale:
 *
 * All fields are private, use the access routines.
 *
 * Since: 3.3
 */
typedef struct _VisuGlExtScale VisuGlExtScale;

/**
 * visu_glExt_scale_get_type:
 *
 * This method returns the type of #VisuGlExtScale, use %VISU_GLEXT_SCALE_TYPE instead.
 *
 * Returns: the type of #VisuGlExtScale.
 *
 * Since: 3.3
 */
GType visu_glExt_scale_get_type(void);


gboolean visu_glExt_scale_setDefaultRGBValues(float rgba[4], int mask);
gboolean visu_glExt_scale_setDefaultLineWidth(float width);
gboolean visu_glExt_scale_setOn(gboolean value);
gboolean visu_glExt_scale_setDefaultStipple(guint16 stipple);

float*   visu_glExt_scale_getDefaultRGBValues();
gboolean visu_glExt_scale_getOn();
float    visu_glExt_scale_getDefaultLineWidth();
guint16  visu_glExt_scale_getDefaultStipple();

void visu_glExt_scale_drawAll(VisuOpenGLCamera *camera, guint winSize);
GList* visu_glExt_scale_getAll();


VisuGlExtScale* visu_glExt_scale_new(float origin[3], float orientation[3],
                                     float length, const gchar *legend);

gboolean visu_glExt_scale_setOrigin(VisuGlExtScale *scale, float xyz[3], int mask);
gboolean visu_glExt_scale_setOrientation(VisuGlExtScale *scale, float xyz[3], int mask);
gboolean visu_glExt_scale_setLength(VisuGlExtScale *scale, float lg);
gboolean visu_glExt_scale_setLegend(VisuGlExtScale *scale, const gchar *value);

const gchar* visu_glExt_scale_getLegend(VisuGlExtScale *scale);
float visu_glExt_scale_getLength(VisuGlExtScale *scale);
float* visu_glExt_scale_getOrigin(VisuGlExtScale *scale);
float* visu_glExt_scale_getOrientation(VisuGlExtScale *scale);

#endif
