/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#ifndef VISU_GTK_H
#define VISU_GTK_H

#include <glib.h>
#include <gtk/gtk.h>
#include "coreTools/toolFileFormat.h"
#include "visu_data.h"

/**
 * visuGtkRaise_warning:
 * @action: a string ;
 * @message: another string ;
 * @window: the parent window to raise the warning on.
 *
 * Raise a warning window with the action in bold and the message written
 * underneath.
 */
void visuGtkRaise_warning(gchar *action, gchar *message, GtkWindow *window);
/**
 * visuGtkRaise_warningLong:
 * @action: a string ;
 * @message: another string ;
 * @window: the parent window to raise the warning on.
 *
 * Same as visuGtkRaise_warning() except that the message is displayed
 * in a text buffer, ideal for a log.
 */
void visuGtkRaise_warningLong(gchar *action, gchar *message, GtkWindow *window);


/**
 * VisuGtkPreview:
 * @check: the widget used to allow or not preview ;
 * @image: the #GtkImage with the preview ;
 * @table: a #GtkTable with file informations ;
 * @vbox: the #GtkVBox with all the stuff for previewing.
 *
 * A container for the relevant widgets of the preview area.
 */
typedef struct VisuGtkPreview_struct
{
  GtkWidget *check;
  GtkWidget *image;
  GtkWidget *table;
  GtkWidget *vbox;
} VisuGtkPreview;

/**
 * visuGtkPreview_add:
 * @preview: a location on #VisuGtkPreview (uninitialised) ;
 * @chooser: the filechooser the preview must be attached to.
 *
 * Create the widgets to have a preview attached to @filechooser. But
 * the signal raised by @filechooser when previewing is needed is not
 * attached and this must be done by the user with custom routine.
 *
 * Returns: @preview itself.
 */
VisuGtkPreview* visuGtkPreview_add(VisuGtkPreview *preview, GtkFileChooser *chooser);
/**
 * visuGtkPreview_update:
 * @preview: a location on #VisuGtkPreview (initialised) ;
 * @filenames: an array of filenames.
 *
 * This routine update the content of the given @preview by making a
 * rendering in a pixmap of the given filenames. The number of given
 * filenames must match the number required by the current rendering
 * method. Only the nodes, the box and the background (plus fog) is
 * actually previewed.
 */
void visuGtkPreview_update(VisuGtkPreview *preview, const char *filenames[]);


/**
 * visuGtkGet_selectedDirectory:
 * @parent: if NULL, the command panel window is used ;
 * @multiple: if TRUE, multiple directories can be selected ;
 * @dir: if not NULL, give the opening directory.
 *
 * General procedure to get the location of one or more directories.
 * In the multiple case, all selected directories shares a common ancestor
 * since the selection is done through the same selector that for single
 * directory but with multiple selection activated. If @dir is NULL
 * the last opened (and stored) directory is used (see
 * gtkMainClassGet_lastOpenDirectory() and gtkMainClassSet_lastOpenDirectory()).
 *
 * Returns: a newly allocated array of paths, NULL terminated. Use g_strfreev()
 *          to free it after use. If no directory is selected, then NULL is
 *          returned.
 */
gchar** visuGtkGet_selectedDirectory(GtkWindow *parent, gboolean multiple,
				     const gchar *dir);

/**
 * visuGtkGet_fileFromDefaultFileChooser:
 * @data: an allocated #VisuData to store the file names ;
 * @parent: the parent window of the dialog.
 *
 * This method is a default method to launch a file chooser that select
 * a single file, with the filters of the current RenderingMethod. It creates a
 * modal dialog, and wait for its reponse. If OK is clicked, the selected
 * filename is stored. If Cancel is clicked, nothing is done. The
 * dialog is destroyed after use.
 *
 * Returns: FALSE if no file has been set, TRUE if the calling method should
 *          call gtkMainLoadAndRender_file() with a g_idle_add() method.
 */
gboolean visuGtkGet_fileFromDefaultFileChooser(VisuData *data, GtkWindow *parent);

/**
 * visuGtkMain:
 * @argc: the number of arguments.
 * @argv: the values of all arguments.
 *
 * It initializses the GTK part of V_Sim: all subpanels,
 * pick and observe window, pair window...
 *
 * Returns: 1 if something goes wrong, 0 otherwise.
 */
int visuGtkMain(int argc, char *argv[]);

/**
 * visuGtkWait:
 *
 * It runs the Gtk event loop, flushing it before returning.
 */
void visuGtkWait();

/**
 * visuGtkLoadAndRender_file:
 * @data: some user defined information.
 *
 * This method loads the general function to load data from file
 * and deals with errors with gtkDialogs.
 *
 * Returns: FALSE, always to stop any idle repetitions.
 */
gboolean visuGtkLoadAndRender_file(gpointer data);

typedef struct FileFilterCustom_struct
{
  GtkFileFilter *gtkFilter;
  FileFormat* visuFilter;
} FileFilterCustom;

/**
 * visuGtkCreate_fileChooserFilter:
 * @list: a GList of #FileFormat ;
 * @fileChooser: a file chooser to associate filters with.
 *
 * Create a list of GtkFileFilter created from the given list of file formats
 * and attach it to the given @fileChooser.
 *
 * Returns: a list of #FileFilterCustom. This list should be freed after use.
 */
GList* visuGtkCreate_fileChooserFilter(GList *list, GtkWidget *fileChooser);

#endif
