/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef GTK_SHADECOMBOBOXWIDGET_H
#define GTK_SHADECOMBOBOXWIDGET_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkcombobox.h>
#include <gtk/gtkliststore.h>

#include <coreTools/toolShade.h>

G_BEGIN_DECLS
/**
 * SHADE_COMBOX_TYPE
 *
 * Return: the associated #GType to the ShadeComboBox objects.
 *
 * Since: 3.3
 */
#define SHADE_COMBOX_TYPE         (shadeComboBox_get_type ())
/**
 * SHADE_COMBOX:
 *
 * Cast the given object to a #ShadeComboBox object.
 *
 * Since: 3.3
 */
#define SHADE_COMBOX(obj)         (G_TYPE_CHECK_INSTANCE_CAST ((obj), SHADE_COMBOX_TYPE, ShadeComboBox))
/**
 * SHADE_COMBOX_CLASS
 *
 * Cast the given class to a #ShadeComboBoxClass object.
 *
 * Since: 3.3
 */
#define SHADE_COMBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SHADE_COMBOX_TYPE, ShadeComboBoxClass))
/**
 * IS_SHADE_COMBOX
 *
 * Returns: if the given object is a valid #ShadeComboBox object.
 *
 * Since: 3.3
 */
#define IS_SHADE_COMBOX(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SHADE_COMBOX_TYPE))
/**
 * IS_SHADE_COMBOX_CLASS
 *
 * Returns: if the given class is a valid #ShadeComboBoxClass class.
 *
 * Since: 3.3
 */
#define IS_SHADE_COMBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SHADE_COMBOX_TYPE))

/**
 * ShadeComboBox
 *
 * Private structure to store informations of a #ShadeComboBox object.
 *
 * Since: 3.3
 */
typedef struct _ShadeComboBox ShadeComboBox;
/* typedef struct ShadeComboBoxPrivate_struct ShadeComboBoxPrivate; */
/**
 * ShadeComboBoxClass
 *
 * Private structure to store informations of a #ShadeComboBoxClass object.
 *
 * Since: 3.3
 */
typedef struct _ShadeComboBoxClass ShadeComboBoxClass;

/**
 * shadeComboBox_get_type
 *
 * #GType are unique numbers to identify objects.
 *
 * Returns: the #GType associated with #ShadeComboBox objects.
 *
 * Since: 3.3
 */
GType shadeComboBox_get_type(void);
/**
 * shadeComboBox_new :
 * @hasAlphaChannel : a boolean.
 *
 * A #ShadeComboBox widget is like a #GtkComboBox widget, but it is already filled
 * with the known shades. Using this widget
 * is a convienient way to share shades between all part of V_Sim and to give a consistent
 * look of all shade selection. If the argument @hasAlphaChannel is FALSE, the widget
 * display all shades but without their alpha channel, assuming it to be fully opaque.
 *
 * Returns: a newly created #ShadeComboBox widget.
 *
 * Since: 3.3
 */
GtkWidget* shadeComboBox_new(gboolean hasAlphaChannel);

/**
 * shadeComboBoxSet_selectionByShade:
 * @shadeComboBox: a #ShadeComboBox widget ;
 * @shade: a #Shade object.
 *
 * Use this method to set the ComboBox on the given shade. This emits a 'shade-channel'
 * signal if the shade is changed, which means, a previous shade has been modified,
 * or a new shade is selected.
 *
 * Returns: TRUE if the @shade already exists in the model.
 *
 * Since: 3.3
 */
gboolean shadeComboBoxSet_selectionByShade(ShadeComboBox* shadeComboBox, Shade *shade);
/**
 * shadeComboBoxGet_selectedShade:
 * @shadeComboBox: a #ShadeComboBox widget.
 *
 * The user can access to the selected #Shade object using this method.
 *
 * Returns: a pointer to the selected #Shade object (or NULL). This object is read-only.
 *
 * Since: 3.3
 */
Shade* shadeComboBoxGet_selectedShade(ShadeComboBox *shadeComboBox);
/**
 * shadeComboBoxGet_pixbufFromShade:
 * @shadeComboBox: a #ShadeComboBox widget ;
 * @shade: a #Shade object.
 *
 * The @shadeComboBox has little pixbufs to represent the shade. User methods can
 * use these pixbufs but should considered them read-only.
 *
 * Returns: a pixbuf pointer corresponding to the little image shown on
 *          the @shadeComboBox.
 *
 * Since: 3.3
 */
GdkPixbuf* shadeComboBoxGet_pixbufFromShade(ShadeComboBox *shadeComboBox, Shade *shade);

/**
 * shadeComboBoxBuild_shadeStamp:
 * @shade: a #Shade object ;
 * @pixbuf: an existing pixbuf (can be NULL).
 *
 * This method is used to create pixbuf representing shades. If @pixbuf is given,
 * it must be a valid pixbuf, and the shade is created in it. Otherwise, a new
 * pixbuf is created.
 *
 * Returns: a pixbuf pointer.
 *
 * Since: 3.3
 */
GdkPixbuf* shadeComboBoxBuild_shadeStamp(Shade *shade, GdkPixbuf *pixbuf);

G_END_DECLS

#endif
