/* XML lowlevel I/O.

   Copyright (C) 2000 Daiki Ueno <ueno@unixuser.org>

   AuthorGroup: Daiki Ueno <ueno@unixuser.org>
   Created: 2000-05-16

   This file is part of UltraPoint.

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2, or (at your option)  
   any later version.                                                   

   This program is distributed in the hope that it will be useful,      
   but WITHOUT ANY WARRANTY; without even the implied warranty of       
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the        
   GNU General Public License for more details.                         

   You should have received a copy of the GNU General Public License    
   along with GNU Emacs; see the file COPYING.  If not, write to the    
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,         
   Boston, MA 02111-1307, USA.                                          

*/

#ifndef __UPT_XML_H_
#define __UPT_XML_H_

#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>

typedef struct _UptXMLSlide UptXMLSlide;
typedef struct _UptXMLSlideShow UptXMLSlideShow;
typedef struct _UptXMLTerm UptXMLTerm;

#include "slide.h"

enum {
  TERM_TEXT = 0,
  TERM_IMAGE = 1
};

enum {
  LIST_DEFAULT = 0,
  LIST_NONE = 0,
  LIST_ITEMIZE = 1,
  LIST_ORDER_DEFAULT = 2,
  LIST_ORDER_ARABIC = 2,
  LIST_ORDER_UPPERALPHA = 3,
  LIST_ORDER_LOWERALPHA = 4,
};

struct _UptXMLTerm {
  gint type;
  gint list_type;

  union {
    gchar *text;
    struct {
      gchar *filename;
      gint width, height;
      gdouble scale;
    } image;
  } data;
};
 
struct _UptXMLSlide {
  gchar *head;
  GNode *body;

  gint ref_count;
  GFreeFunc free;
};

struct _UptXMLSlideShow {
  gchar *title;
  gchar *author;
  gchar *affiliation;
  gchar *email;

  GList *slides;
  GList *current_slide;

  gint ref_count;
  GFreeFunc free;
};

UptXMLSlideShow *upt_parse_file (gchar *filename, gchar *dtd);

#endif
