#include "cs.h"
/* p [0..n] = cumulative sum of c [0..n-1], and then copy p [0..n-1] into c */
CS_INT cs_cumsum (CS_INT *p, CS_INT *c, CS_INT n)
{
    CS_INT i, nz = 0 ;
    if (!p || !c) return (-1) ;	    /* check inputs */
    for (i = 0 ; i < n ; i++)
    {
	p [i] = nz ;
	nz += c [i] ;
	c [i] = p [i] ;
    }
    p [n] = nz ;
    return (nz) ;		    /* return sum (c [0..n-1]) */
}
