/* twpsk  - PSK31 for Linux with a Motif interface
 * Copyright (C) 1999-2005 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 2.1 - Aug 2002
 *
 * Portions derived from:
 * Soundcard-based implementation of the PSK31 HF keyboard-to-keyboard mode
 * Copyright (C) 1998  Hansi Reiser, DL9RDZ
 */

#include "GUI.h"
#include "../server/server.h"
#include "twpskWids.h"
#include "decoderWids.h"
#include "twpskCB.h"
#include "twpskScope.h"
#include "twpskWF.h"
#include "twpskHelp.h"
#include "callbox.h"
#include <signal.h>


extern int scconfig[];		// [0]==8bit/16bit [1]==mono/stereo 
int OPTnew = 0;   // todo: rausdamit (-> filter and sync alg selection for RX)

/* Globals */
AppRes appRes;
Position winlocs[MAX_DECODERS][2];
Widget shell;
Wids pskwids;
Scope scope;
Disp disp;
Help help;
TwpskCB twpskCB;
XtAppContext ac;
MixVals saveMix; 

/* @@@ DL9RDZ */
#include "catWids.h"
#include "decoderWids.h"

Cat catwids;

DecoderWid decoderWids[MAX_DECODERS];
   
/*
 * main - main function for twpsk
 */
int main(int argc, char *argv[])
{

   Widget temp;
   Widget  noTwpskMessBox, infoDiag;
   int height = 0, width = 0;
   XmString messStr;
   char *str = "";
   int rtn;
   Atom wm_delete_win;
   XmString xs;
   String info[] =
   {
      "Not Used!",
      "Failed to configure as 8 bits - try another configuration",
      "Failed to configure as 16 bits - try another configuration",
      "Failed to configure as mono - try another configuration",
      "Failed to configure as stereo - try another configuration"
   };


   String fallback_resources[] =
     {
     "twpsk.noTwpskMessBox*forground:     black",
     "twpsk.noTwpskMessBox*background:    tan",
     "twpsk.noTwpskMessBox.messageString: Can't find the resource file, Twpsk.",
      NULL
      };

   XtResource appRes_desc[] =
   {
      {
      XmNbuttonNames,                    /* Resource Name */ 
      XmCButtonNames,                    /* Resource Class */
      XmRString,                         /* Resource Data Type */
      sizeof (char),                     /* Size of Resource */
      XtOffsetOf (AppRes, buttonNames),  /* Offset into Struct */
      XtRString,                         /* Default Data Type */
      (XtPointer) "Bogus Name"           /* Default Value */
      },
      {
      XmNxmitHighlight,                  /* Same as above */
      XmCXmitHighlight,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, xmitHighlight),
      XtRInt,
      (XtPointer) 0
      },


      {
      XmNrxFreq,                         /* Same as above */
      XmCRxFreq,
      XmRFloat,
      sizeof (float),
      XtOffsetOf (AppRes, rxFreq),
      XtRFloat,
      (XtPointer) 0
      },

      {
      XmNtxFreq,                         /* Same as above */
      XmCTxFreq,
      XmRFloat,
      sizeof (float),
      XtOffsetOf (AppRes, txFreq),
      XtRFloat,
      (XtPointer) 0
      },

      {
      XmNafc,                            /* Same as above */
      XmCAfc,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, afc),
      XtRInt,
      (XtPointer) 0
      },

      {
      XmNnet,                            /* Same as above */
      XmCNet,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, net),
      XtRInt,
      (XtPointer) 0
      },

      {
      XmNnoMixer,                        /* Same as above */
      XmCNoMixer,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, noMixer),
      XtRInt,
      (XtPointer) 1
      },

      {
      XmNmainVol,                        /* Same as above */
      XmCMainVol,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, mainVol),
      XtRFloat,
      (XtPointer) 0
      },

      {
      XmNoutVol,                         /* Same as above */
      XmCOutVol,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, outVol),
      XtRFloat,
      (XtPointer) 0
      },

      {
      XmNinVol,                          /* Same as above */
      XmCInVol,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, inVol),
      XtRImmediate,
      (XtPointer) 0
      },

      {
      XmNcall,                           /* Same as above */
      XmCCall,
      XmRString,
      sizeof (char),
      XtOffsetOf (AppRes, call),
      XtRImmediate,
      (XtPointer) " ",
      },

      {
      XmNzero,                           /* Same as above */
      XmCZero,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, zero),
      XtRImmediate,
      (XtPointer) 0
      },

      {
      XmNptt,                            /* Same as above */
      XmCPtt,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, ptt),
      XtRImmediate,
      (XtPointer) 0
      },

      {
      XmNserDev,                         /* Same as above */
      XmCSerDev,
      XmRString,
      sizeof (char),
      XtOffsetOf (AppRes, serDev),
      XtRImmediate,
      (XtPointer) "/dev/ttyS1",
      },

      {
      XmNaudioDev,                       /* Same as above */
      XmCAudioDev,
      XmRString,
      sizeof (char),
      XtOffsetOf (AppRes, audioDev),
      XtRImmediate,
      (XtPointer) "/dev/audio",
      },

      {
      XmNcallBox,                        /* Same as above */
      XmCCallBox,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, callBox),
      XtRImmediate,
      (XtPointer) 0
      },
   };


#ifdef XmVERSION_STRING
   extern const char _XmVersionString[];
   fprintf (stderr, "Compiled with %s\n", XmVERSION_STRING);
   fprintf (stderr, "Running  with %s\n", _XmVersionString); 
#endif

   /*
    * Create the shell, register a callback for the WM Close button,
    * catch the INT, QUIT, and TERM signals, and read the resource file
    * if Twpsk was found.
    */
   shell = XtVaAppInitialize (&ac, "Twpsk", NULL, 0, &argc, argv,
      fallback_resources,
      XmNiconName, "TWPSK",
      NULL);

   wm_delete_win = XmInternAtom (XtDisplay(shell), "WM_DELETE_WINDOW", False);
   XmAddWMProtocolCallback (shell, wm_delete_win, quitCB, NULL);

   signal (SIGINT,  gotSig);
   signal (SIGQUIT, gotSig);
   signal (SIGTERM, gotSig);

   /*
    * Create an error message box just in case.
    * If the label != "OK", then we're running on
    * the fallback resources.  Popup the dialog
    * and tell them to fix Twpsk
    */
   noTwpskMessBox = XtVaCreateManagedWidget("noTwpskMessBox",
      xmMessageBoxWidgetClass, shell, 
      NULL);

   XtVaGetValues (noTwpskMessBox,
      XmNmessageString, &messStr,
      NULL);

   XmStringGetLtoR (messStr, XmFONTLIST_DEFAULT_TAG, &str);

   if (strcmp(str,"OK") != 0)  /* didn't find Twpsk in X11's app-defaults*/
                               /* did you run make install_twpsk as root? */
   {
      /* Get rid of the Cancel and Help buttons */
      temp = XmMessageBoxGetChild (noTwpskMessBox, XmDIALOG_CANCEL_BUTTON);
      XtUnmanageChild(temp);

      temp = XmMessageBoxGetChild (noTwpskMessBox, XmDIALOG_HELP_BUTTON);
      XtUnmanageChild(temp);

      /* Have the OK button call the quitCB. cdata = -1 (stops 2nd Rx save) */
      temp = XmMessageBoxGetChild (noTwpskMessBox, XmDIALOG_OK_BUTTON);
      XtAddCallback (temp, XmNactivateCallback, quitCB, (XtPointer) -1);

      /* bail out to an event loop with just the message box */
      XtRealizeWidget(shell);
      XtAppMainLoop(ac);
   }

   /* Got Twpsk, so don't need the message box */
   XtDestroyWidget (noTwpskMessBox);

   /* Get the app resources from the resource file */
   XtGetApplicationResources (shell, &appRes, appRes_desc,
      XtNumber (appRes_desc), NULL, 0);

   /*
    * Read parameters from ~/twpskDir/.twpsk.dat 
    */
   iniProc ('r');  /* read window locations */

   /*
    * Initialize the mixer, if desired
    */
   if (appRes.noMixer == 0)
   {
      rtn = init_mixer();
      if (rtn == -1)
      {
         fprintf (stderr, "twpsk - MIXER SETUP FAILED - PLEASE USE A MIXER PROGRAM TO SETUP THE MIXER.\n");
      }
   }

   /*
    * initialize server
    * psk31.cod is installed in /usr/local/share/psk31
    */
   if (( rtn = server_main(appRes.audioDev,
       appRes.ptt ? appRes.serDev : NULL, "/usr/local/share/psk31")) == -1)
   {
	   fprintf(stderr,"failed to initialize psk31 server\n");
	   exit(1);
   }

   /*
    * Create widgets and then check the soundcard config (rtn)
    */
   pskwids.buildWidgets (shell, &appRes);  

   /* 
    * check soundcard config
    */
   if (rtn != 0)
   {
      infoDiag = XmCreateInformationDialog (shell, "infoDiag", NULL, 0);
      XtUnmanageChild (XmMessageBoxGetChild
                               (infoDiag, XmDIALOG_HELP_BUTTON));
      XtUnmanageChild (XmMessageBoxGetChild
                               (infoDiag, XmDIALOG_CANCEL_BUTTON));
      XtVaSetValues (XtParent(infoDiag),
         XmNtitle, "Configuration Error!",
         NULL);

      xs = XmStringCreateLocalized (info[rtn]);
      XtVaSetValues (infoDiag,
         XmNmessageString, xs,
         NULL);
      XmStringFree (xs);
      XtManageChild (infoDiag);
   }

   /*
    * Tell the help class about the shell.
    */
   help.setShell (shell);  

   /* @@@DL9RDZ
    * test 2nd window
    */
   // catwids.buildWidgets(shell, &appRes);

   DecoderWid::shell = shell;
   for(int i=0; i<MAX_DECODERS; i++)
   {
       decoderWids[i].visible = -1;
   }

   /* Add callbox if desired */
   if ( appRes.callBox == 1 )
   {
      fprintf (stderr,"starting callbox\n");
      Callbox a_callbox (shell);
      a_callbox.quiet();
   }

   /*
    * setup and initialize the scope and display
    */
   scope.setup (shell, pskwids.getScope());
   disp.setup(pskwids.getWF());

   /*
    * Set min size
    */
   XtVaGetValues (shell,
      XmNwidth, &width,
      XmNheight, &height,
      NULL);

   XtVaSetValues (shell,
      XmNminWidth, width,
      XmNminHeight, height,
      NULL);
   

   /*
    * Start the application work proc
    * and enter the main loop
    */
   XtAppAddWorkProc (ac, workProc, (XtPointer) NULL);
   XtAppMainLoop (ac); 
}


/*
 * iniProc - read/write the window locations to a file 
 * read - stat to see if file exists. If it does, read it.
 * If not, skip it.  We will create it on exit for next time
 *
 * write - just over writes the ini file with the current arrays
 * See the quitCB for changes to the array.
 */
void iniProc (char mode)
{
   struct stat file_stat;
   char *filepath, *homepath;
   FILE *fp = NULL;
   char str[6], *rtn;
   int i;

   homepath = getenv("HOME");
   filepath = (char *) malloc (strlen (homepath) + strlen (DAT_FILE) + 2);
   strcpy (filepath, homepath);
   strcat (filepath, DAT_FILE);

   switch (mode)
   {
   case 'r':
      if (stat (filepath, &file_stat) == -1)
      {
         fprintf (stderr, "iniProc: no %s file yet.\n", filepath);
         /*
          * no file - this may be the first time we ran, so set
          * winlocs and scconfig to some nice defaults
          */
         for (i=0; i<MAX_DECODERS; i++)
         {
            winlocs[i][0] = 50;
            winlocs[i][1] = 50;
         }
         scconfig[0] = 1;
         scconfig[1] = 1;
      }
      else
      {
         if ((fp = fopen (filepath, "r")) == NULL)
         {
            fprintf (stderr, "iniProc: open .twpsk.dat for read failed\n");
         }
         else
         {
            fprintf (stderr, "reading %s \n", filepath);
            for (i=0; i<MAX_DECODERS; i++)    /* for the secondary locations */
            {
               rtn = fgets (str, 7, fp);
               if (rtn != str)                /* no data in file so default */
               {
                 strcpy (str, "50");
               }
               winlocs[i][0] = atoi(str);               
               rtn = fgets (str, 7, fp);
               if (rtn != str)                /* no data in file so default */
               {
                 strcpy (str, "50");
               }
               winlocs[i][1] = atoi(str);               
            }
            for (i=0; i<2; i++)               /* for the soundcard params */
            {
               rtn = fgets (str, 3, fp);
               if (rtn != str)                /* no data in file so default */
               {
                 strcpy (str, "1");
               }
               scconfig[i] = atoi(str);
            }
         }
      }
      free (filepath);
      return;

   case 'w':
      fprintf (stderr, "writing %s\n", filepath);
      if ((fp = fopen (filepath, "w")) == NULL)
      {
         fprintf (stderr, "iniProc: open .twpsk.dat for write failed\n");
         return;
      }
      for (i=0; i<MAX_DECODERS; i++)         // for the secondary locations
      {
         fprintf (fp, "%d\n%d\n", winlocs[i][0], winlocs[i][1]);
      }

      // for the soundcard params
      fprintf (fp, "%d\n", scconfig[0]);
      fprintf (fp, "%d\n", scconfig[1]);

      free (filepath);
      fclose (fp);
      return; 

   default:
      fprintf (stderr, "iniProc: illegal call\n");
      return;
   }
}  


#ifndef USE_PTHREAD
void master_handler(void);
#endif


/*
 * workProcFunction
 * Work Proceedure for receive and transmit
 */
Boolean workProc(XtPointer cdata)
{
   PSK31info rxinfo, txinfo;
   char str[8];
   static float rxfreqOld;
   int phdelta;  
   int l;   
   int rxecho;

#ifndef USE_PTHREAD
   // 4 is an empirical value.
   // If choosen too low, sound card buffer will run empty, and thus sound
   // will have interruptions (fatal!). A value too high isn't that critical...
   for(int i=0; i<4; i++) 
   {
      master_handler();
#endif
      // handle FFT!
      int N = disp.getsamplecnt();
      float fftval[N];
      l = commGetData(COMM_FFTCH, (char *)fftval, sizeof(fftval));
      if (l > 0)
      {
         if (l != N)
         {
            fprintf(stderr,"FFT len mismatch: l=%d N=%d\n",l,N);
         }
         disp.getFFT (fftval, N);
      }
#ifndef USE_PTHREAD
   }
#endif
   char buf[256];
   
   /*
    * handle transmit echo!  We could use a different color?
    * Sri, Hansi.  Best I can do is to underline or highlight it.
    */
   rxecho = commGetData(COMM_ECHOCH, buf, sizeof buf);
   if(rxecho > 0)
   {
      for(int i=0; i<rxecho; i++)
      {
         appendRXtext(pskwids.getRxText(), buf[i],
                      appRes.zero, (XmHighlightMode)appRes.xmitHighlight);
                      //appRes.zero, XmHIGHLIGHT_SECONDARY_SELECTED);
      }
   }
   commGetInfo(COMM_TXCH, &txinfo, sizeof(txinfo));
   //(TODO) well I probably dont really need this info... 
   //txfreq = 0.01 * txinfo.freq;

   /*
    * handle receive!
    */
   l = commGetData(COMM_RXCH, buf, sizeof buf);
   if(l > 0)
   {
      for(int i=0; i<l; i++)
         appendRXtext(pskwids.getRxText(), buf[i],
                      appRes.zero, XmHIGHLIGHT_NORMAL);
   }

   commGetInfo(COMM_RXCH, &rxinfo, sizeof(rxinfo));
   appRes.rxFreq = 0.01 * rxinfo.freq;
   phdelta = rxinfo.phdelta;
   
   /*update DCD toggle button*/
   XtVaSetValues(pskwids.getDcdTB(), XmNset, rxinfo.dcd, NULL);

   if(rxinfo.ptt == 0)
   {
      /* receiving */
      /* update scope */
      scope.drawline(rxinfo.phdelta, rxinfo.strength, rxinfo.dcd);

      /* update rx freq */
      /* but only if focusFlag == 0 */
      if (pskwids.getRxFreqFocus() == 0 )
      {
         if (fabs(appRes.rxFreq - rxfreqOld) > .05)
         {
            sprintf (str, "%4.1f", appRes.rxFreq);
            XmTextFieldSetString (pskwids.getRxFreqTF(), str);
            /* tell the fft about it */
            disp.offset(appRes.rxFreq);
            rxfreqOld = appRes.rxFreq;
         }
      }
   }
   else
   {
      /* scope display for each tx character put in the echo (rx) window */
      if(rxecho>0)
         phdelta = 0;
      else
         phdelta = 128;
      scope.drawline(phdelta, 35, GREEN);
   }

   /* handle receive for additional receivers! */
   for(int ch=0; ch<MAX_DECODERS; ch++)
   {
      if( decoderWids[ch].visible!=1) continue;
         l = commGetData(ch+3, buf, sizeof buf);
      if(l>0)
      {
         for(int i=0; i<l; i++)
            appendRXtext(decoderWids[ch].getTextWid(), buf[i],
                         appRes.zero, XmHIGHLIGHT_NORMAL);
      }
      l = commGetInfo(decoderWids[ch].commChannel, &rxinfo, sizeof(rxinfo));
      if(l==0)
      {
         decoderWids[ch].updateDisplay(0.01*rxinfo.freq, rxinfo.dcd, 0);
         decoderWids[ch].getScope().drawline(rxinfo.phdelta, 
            rxinfo.strength, rxinfo.dcd);
      }
   }

#ifdef USE_PTHREAD
   usleep(10000);
#else
   usleep(5000);
#endif

   return (False);
}


void gotSig (int stat)
{
   if (stat == SIGINT)
   {
      fprintf (stderr, "INTERRUPT\n");
      signal (SIGINT, SIG_IGN);
      quitCB ((Widget)0, (XtPointer)0, (XtPointer)0);
      exit (0);
   }
   if (stat == SIGQUIT)
   {
      fprintf (stderr, "QUIT\n");
      signal (SIGINT, SIG_IGN);
      quitCB ((Widget)0, (XtPointer)0, (XtPointer)0);
      exit (0);
   }
}


/*
 * Initialize the mixer if requested.
 * Save the mixer's current state so we can restore the values
 * when done. Set record source to line-in if possible,
 * otherwise use the mic input.
 */
int init_mixer ()
{
   int mixer_fd;
   int val, recmask; 

   /* Open the mixer */
   mixer_fd = open("/dev/mixer",O_RDWR);
   if (mixer_fd < 0)
   {
      perror ("init_mixer - Can't open mixer");
      return -1;
   }

   /*
    * Get and save the current mixer values so we can restore
    * then when we quit.
    */
   if (ioctl (mixer_fd, SOUND_MIXER_READ_RECSRC, &saveMix.recsrc) < 0)
   {
      perror ("init_mixer: can't read recsrc\n");
      close (mixer_fd);
      return -1;
   }

   if (ioctl (mixer_fd, SOUND_MIXER_READ_VOLUME, &saveMix.vol) < 0)
   {
      perror ("init_mixer: can't read volume level\n");
      close (mixer_fd);
      return -1;
   }

   if (ioctl (mixer_fd, SOUND_MIXER_READ_PCM, &saveMix.pcm) < 0)
   {
      perror ("init_mixer: can't read pcm level\n");
      close (mixer_fd);
      return -1;
   }

   // only save the recsrc values that twpsk might change
   if (ioctl (mixer_fd, SOUND_MIXER_READ_LINE, &saveMix.line) < 0)
   {
      perror ("init_mixer: can't read line-in level\n");
      close (mixer_fd);
      return -1;
   }

   if (ioctl (mixer_fd, SOUND_MIXER_READ_MIC, &saveMix.mic) < 0)
   {
      perror ("init_mixer: can't read mic level\n");
      close (mixer_fd);
      return -1;
   }

   /*
    * Read the record mask to see what is available 
    * First choice is the line-in, second choice is the mic
    */
   if (ioctl (mixer_fd, SOUND_MIXER_READ_RECMASK, &recmask))
   {
      perror("init_mixer - can't read mixer recmask");
      close (mixer_fd);
      return -1;
   }


   /* Use the line in if we can */
   if ((recmask & SOUND_MASK_LINE) == SOUND_MASK_LINE)
   {
      val = SOUND_MASK_LINE;
      saveMix.useRec = SOUND_MIXER_LINE;
      fprintf (stderr, "init_mixer: using the mixer line-in\n");
   }
   else
   {
      /* Otherwise, we use the mic input */
      if ((recmask & SOUND_MASK_MIC) == SOUND_MASK_MIC)
      {
         val = SOUND_MASK_MIC;
         saveMix.useRec = SOUND_MIXER_MIC;
         fprintf (stderr, "init_mixer: using the mixer mic input\n");
      }
      /* What? No line-in or mic. Bail out! */
      else
      {
         fprintf (stderr, "init_mixer: can't set recsrc to mic or line\n");
         return -1;
      }
   } 

   /*
    * Set the record source to the value selected above
    */
   if (ioctl (mixer_fd, SOUND_MIXER_WRITE_RECSRC, &val) < 0)
   {
      perror ("init_mixer: can't set recsrc\n");
      close (mixer_fd);
      return -1;
   }

   close (mixer_fd);
   return 0;
}

