<?php

 // We need a few functions from the contacts feature to display the contact lists
 if( !$included["features/shared/contacts.inc.php3"] ) { include( "features/shared/contacts.inc.php3" ); }

 if( !isset( $ItemID ) && isset( $data["id"] ) ) { $ItemID = $data["id"]; }

 list( $thisHour, $thisMinute, $extra_thisDays ) = TWIGTimeCleanup( $thisHour, $thisMinute, $thisAMPM );
 list( $thisYear, $thisMonth, $thisDay )  = TWIGDateCleanup( $thisYear, $thisMonth, $thisDay, $extra_thisDays );
 $data["itemdone"] = createSqlDateTime( $thisYear,  $thisMonth,  $thisDay, $thisHour, $thisMinute, 0 );

 $ret = TWIGListItemEditProcess(  "edit", $dbconfig["meetings_table"], $groupquery, $data );
 if( $ret != FALSE && $ret != TRUE )
 	{
 	TWIGPrintError( $ret );
 	}

 $i = 0;
 $menu[$i] = array( "command" => "meetings", "desc" => TWIGPhrase( "Back to Meetings" ), "action" => "main", "options" => "list=0", "target" => "", "image" => "registered.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => TWIGPhrase( "View details" ), "action" => "view", "options" => "ItemID=$ItemID", "target" => "", "image" => "public.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => TWIGPhrase( "Edit notes" ), "action" => "notes", "options" => "ItemID=$ItemID", "target" => "", "image" => "public.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => TWIGPhrase( "Edit todo" ), "action" => "todo", "options" => "ItemID=$ItemID", "target" => "", "image" => "public.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => TWIGPhrase( "Edit invitees" ), "action" => "invite", "options" => "ItemID=$ItemID", "target" => "", "image" => "public.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => TWIGPhrase( "Reschedule" ), "action" => "edit", "options" => "ItemID=$ItemID", "target" => "", "image" => "private.gif" ); $i++;

 $data = TWIGListGetItem( $ItemID, $dbconfig["meeting_table"], "*", $GroupQuery);
 echo TWIGListItemHeader( $data, "edit", $menu );

 // I'm not sure if this works as intended.
 // What I mean to do is to ignore the db (and thereby use today's date)
 // in the event that the db has not had a date set yet.
 if( $thisDate != 0 )
 	{
 	$thisDate = convertSQLTimetoUTime( $data["itemdone"] );
 	list( $thisYear, $thisMonth, $thisDay, $thisHour, $thisMinute ) = TWIGDateTimeFromUTime( $thisDate );
 	}

// TWIGListItemEditProcess assumes that groupid will be passed
// if it is not, the groupid is reset to 0 (unfiled)
// So we just have to make sure to pass it along to the next page load
?>
<INPUT TYPE="hidden" NAME="data[groupid]" VALUE="<?php echo $data["groupid"]; ?>">

<TABLE BORDER="0" CELLSPACING="0" cellpadding="5" class="formbody">
 <tr>
  <td colspan=2 class="tabletitlesmall">
   <table width="100%" BORDER="0" CELLSPACING="0" cellpadding="0"><tr><td class="tabletitlelarge">
   <?php
     echo TWIGPhrase( "Edit Meeting ToDo" );
   ?>
   </td><td align="right">
   <?php echo TWIGPhrase( "Added by: %1",  array( TWIGMailto( $data["username"] ) ) ); ?>
   </td></tr></table>
  </td>
 </tr>
  <TR>
    <TD COLSPAN="2">
      <b><?php echo TWIGPhrase( "Meeting Name" ); ?></b>:<br>
      <?php echo TWIGmassage( $data["item"] ); ?>
    </TD>
  </TR>
<?php
// Tags were broken with a - between <> and ?. Remove to enable. 
//  <TR>
//    <TD BGCOLOR="<-?php echo $config["cellcolor"]; ?->" COLSPAN="1">
//      <font face=<-?php echo $config["cellfont"]?-> size=<-?php echo $config["textfontsize"];?-> color=<-?php echo $fontcolor?->><b><-?php echo TWIGPhrase( "Type" ); ?-></b>:<br>
//      <-?php echo TWIGmassage( $data["type"] ); ?->
//    </TD>
//    <TD BGCOLOR="<-?php echo $config["cellcolor"]; ?->" COLSPAN="1">
//      <font face=<-?php echo $config["cellfont"]?-> size=<-?php echo $config["textfontsize"];?-> color=<-?php echo $fontcolor?->><b><-?php echo TWIGPhrase( "Location" ); ?-></b>:<br>
//      <-?php echo TWIGmassage( $data["location"] ); ?->
//    </TD>
//  </TR>
?>
  <TR>
    <TD COLSPAN="2">
      <b><?php echo TWIGPhrase( "Last Modified" ); ?></b>:<br>
      <?php echo date( $config["longdateformat"], convertSQLTimetoUTime( $data["thedate"] )); ?>
    </TD>
  </TR>
  <TR>
    <TD NOWRAP VALIGN="top">
      <b><?php echo TWIGPhrase( "Person Responsible" ); ?></b>:<br>
      <?php

 // Unfortunately, TWIGGenerateContactsList does no good for us,
 // since we need to display a SELECTED item.
 // We still check to see if you're allowed to get at the contacts.
 if( TWIGCheckACL( $login["username"], 2003, TWIGConvertAccess( "read" ) ) )
	{
	$sortorder = array( "name"=>"lastname,firstname", "company"=>"company", "group"=>"groupid", "email"=>"email" );
 	$orderby = $sortorder[GetPref( "sortby", $dbconfig["contacts_prefs_table"], $config["defaults"]["contacts"]["sortby"] )];
 	if( !$orderby ) { $orderby = $sortorder["name"]; }
	
	// Get the mycontact of the group's owner
	$query0 = "select g.owner, g.id, c.username, c.firstname, c.lastname, c.email, c.email2, c.email3 from " . $dbconfig["contact_table"] . " as c, " . $dbconfig["groups_table"] . " as g where c.username = g.owner AND c.userpers = '1' AND g.id = '" . $data["groupid"] . "' ORDER BY " . $orderby;
	// Get the mycontact of the group's members
	$query1 = "select m.username, m.groupid, c.username, c.firstname, c.lastname, c.email, c.email2, c.email3 from " . $dbconfig["contact_table"] . " as c, " . $dbconfig["members_table"] . " as m where c.username = m.username AND c.userpers = '1' AND m.groupid = '" . $data["groupid"] . "' ORDER BY " . $orderby;
	// Get the mycontact of those who have already been invited,
	// even though they aren't in the group (the group might have been changed at some point).
	// There's no need to worry about selecting the same username in more than one
	// of these queries, because the array is indexed by username, and so each user
	// can be listed only once; trying to list him again just "overwrites" the first entry.
	$query2 = "select r.username, c.username, c.firstname, c.lastname, c.email, c.email2, c.email3 from " . $dbconfig["contact_table"] . " as c, " . $dbconfig["meetings_inv_table"] . " as r where c.username = r.username AND c.userpers = '1' ORDER BY " . $orderby;
	// Do this thrice, to get group owner, members and non-group people already involved

	for( $q = 0; $q < 3; $q++ )
		{
		// Yeah, this is pretty hackish...
		$query = "query$q";
		TWIGDebug( $$query );
		$result = dbQuery( $$query );

		for( $i = 0, $j = dbNumRows( $result ); $i < $j; $i++ )
			{
			$cdata = dbResultArray( $result, $i );
	
			$personal = trim( $cdata["firstname"] . " " . $cdata["lastname"] );
			if( $personal )
				{
				$label = "&quot;" . $personal . "&quot; ";
				}
			else
				{
				unset( $label ); // Don't keep values from a previous loop
				}
			if( $cdata["email"]  )
				{
				$reslist[$cdata["username"]] = $label . "&lt;" . $cdata["email"]  . "&gt;";
				}
			if( $cdata["email2"] )
				{
				$reslist[$cdata["username"]] = $label . "&lt;" . $cdata["email2"]  . "&gt;";
				}
			if( $cdata["email3"] )
				{
				$reslist[$cdata["username"]] = $label . "&lt;" . $cdata["email3"]  . "&gt;";
				}
			if( $cdata["type"] == 2 )
				{
				$reslist[$cdata["item"]] = TWIGPhrase( "List" ) . ": " . $cdata["item"];
				}
			}
		}
 	echo "<select name=data[responsible] size=5>\n";
	// First show the selected person responsible
	if( $reslist[$data["responsible"]] )
		{
		echo " <option value=\"", $data["responsible"], "\" selected>", $reslist[$data["responsible"]], "</option>\n";
		echo " <option value=\"", $data["responsible"], "\">---  ", TWIGPhrase( "Person Responsible" ), "  ---</option>\n";
		unset( $reslist[$data["responsible"]] ); // Don't show the same name again later
		}
	// Now play back the whole thing
	while( list( $key, $val ) = each( $reslist ) )
		{
		echo " <option value=\"", $key, "\">", $val, "</option>\n";
		}
 	echo "</select>\n";
	}

      ?>
    </TD>
    <TD NOWRAP VALIGN="top">
      <b><?php echo TWIGPhrase( "Due Date" ); ?></b>:<br>
      <?php echo TWIGDateSelector( "this", $thisYear, $thisMonth, $thisDay ); ?>
    </TD>
  </TR>
  <TR>
    <TD COLSPAN="2">
      <b><?php echo TWIGPhrase( "Action Items" ); ?></b>:<br>
      <?php
		echo "<TEXTAREA NAME='data[actionitems]' ROWS='15' COLS='78' WRAP='hard'>\n";
		echo TWIGmassage( $data["actionitems"] ) . "\n";
		echo "      </TEXTAREA>\n";
      ?>
    </TD>
  </TR>
</TABLE>

<?php
 if( TWIGGroupsMemberOf( $data["groupid"], 2 ) )
 	{
	$buttons = "<input type=\"submit\" name=\"submitbutton[update]\" value=\"" . TWIGPhrase( "Update" ) . "\">\n";
	}
 echo TWIGListItemFooter( $data, "edit", $buttons );
?>

