<?php
 require( "lib/groups/" . $config["groups"] . "/" . $config["groups"] . ".inc.php3" );

Function BMAddRecord( $fields, $group, $overwrite )
	{
	GLOBAL $dbconfig, $login;

	TWIGDebug( "BMAddRecord( \$fields, \"" . $group . "\", \"" . $overwrite . "\" )", 20 );

	$groupmlist = TWIGGroupsMembership( $login["username"] );
	$groupolist = TWIGGroupsOwnership( $login["username"] );

	foreach( $groupmlist as $gid )
		{
		$groupnamelist[TWIGGroupsGetName( $gid )] = $gid;
		}

	foreach( $groupolist as $gid )
		{
		$groupnamelist[TWIGGroupsGetName( $gid )] = $gid;
		}

	$data["username"] = $login["username"];
	$data["groupid"] = $groupnamelist[$group];
	$data["item"] = $fields["name"];
	$data["url"] = $fields["url"];
	$data["description"] = $fields["description"];

	if( $overwrite = "overwrite" )
		{
		$result = dbQuery( "SELECT id FROM " . $dbconfig["bookmarks_table"] . " WHERE url = '" . SQLString( $fields["url"] ) . "'" );

		if( dbNumRows( $result ) == 1 )
			{
			$recid = dbResult( $result, 0, "id" );
			$query = "UPDATE " . $dbconfig["bookmarks_table"] . " SET " . MakeUpdateString( $data ) . " WHERE id = '" . $recid . "'";
			TWIGDebug( $query );
			$result = dbQuery( $query ); 
			}
		else
			{
			$ins = MakeInsertString( $data );
			$query = "INSERT INTO " . $dbconfig["bookmarks_table"] . " (" . $ins["fields"] . ") VALUES (" . $ins["values"] . ")";
			TWIGDebug( $query );
			$result = dbQuery( $query ); 
			}
		}
	else
		{
		$ins = MakeInsertString( $data );
		$query = "INSERT INTO " . $dbconfig["bookmarks_table"] . " (" . $ins["fields"] . ") VALUES (" . $ins["values"] . ")";
		TWIGDebug( $query );
		$result = dbQuery( $query );
		}
	}

function ReadOperaAdrFile( $file )
	{
	TWIGDebug( "ReadOperaAdrFile( \"" . $file . "\" )" );
	$fhandle = fopen( $file, "r" );

	if( $fhandle == FALSE ) { return FALSE; }

	if( !feof( $fhandle ) )
		{
		$buffer = fgets( $fhandle, 4096 );

		if( strpos( $buffer, "Opera Hotlist version 2.0" ) === FALSE ) 
			{
			TWIGPrintError( TWIGPhrase( "Unsupported Opera File Version" ) );

			return FALSE;
			}
		}
	$result["root"] = array( "name" => "Unfiled", "description" => "Root Folder", "parent" => "root" );
	$currentfolder = "root";
	$currentlevel = 0;
	$result[$currentfolder]["itemcount"] = 0;
	$result[$currentfolder]["level"] = 0;

	while( !feof( $fhandle ) )
        	{
        	$buffer = trim( fgets( $fhandle, 4096 ) );

		if( $buffer != "" )
			{
			if( strpos( $buffer, "FOLDER" ) == 1 )
				{
				$lastfolder = $currentfolder;
				$currentlevel += 1;
				
				$subitem = ReadOperaSubItem( $fhandle );

				$currentfolder = $subitem["name"];

				$result[$currentfolder]["name"] = $currentfolder;
				$result[$currentfolder]["description"] = $subitem["description"];

				$result[$currentfolder]["parent"] = $lastfolder;
				$result[$currentfolder]["level"] = $currentlevel;
				$result[$currentfolder]["itemcount"] = 0;
				}

			if( strpos( $buffer, "URL" ) == 1 )
				{
				$subitem = ReadOperaSubItem( $fhandle );

				$i = $result[$currentfolder]["itemcount"];
				$result[$currentfolder][$i]["name"] = $subitem["name"];
				$result[$currentfolder][$i]["url"] = $subitem["url"];
				$result[$currentfolder][$i]["description"] = $subitem["description"]; 
				$result[$currentfolder]["itemcount"] += 1;
				}

			if( $buffer == "-" )
				{
				$currentfolder = $result[$currentfolder]["parent"];
				$currentlevel -= 1;
				}
			}
        	}

	fclose( $fhandle );

	return $result;
	}

Function ReadOperaSubItem( $fhandle )
	{
	TWIGDebug( "ReadOperaSubItem( \$fhandle )", 20 );

	if( !feof( $fhandle ) )
		{
		$buffer = trim( fgets( $fhandle, 4096 ) );

		while( !feof( $fhandle ) and $buffer != "" )
			{
			$marker = strpos( $buffer, "=" );
			$result[strtolower(substr( $buffer, 0, $marker ))] = substr( $buffer, $marker + 1 );

			$buffer = trim( fgets( $fhandle, 4096 ) );
			}
		}

	return $result;
	}

Function BMImport( $filename, $type, $groupsep, $overwrite )
	{
	GLOBAL $login, $dbconfig;

	TWIGDebug( "BMImport( \"" . $filename .  "\", \"" . $type . "\", \"" . $groupsep . "\", \"" . $overwrite . "\" )" );

	if( strtolower( $type ) == "opera" )
		{
		$records = ReadOperaAdrFile( $filename );
		}
	else
		{
		return FALSE;
		}

	if( $overwrite == "flush" )
		{
		TWIGDebug( "Flusing bookmarks from database..." );
	        $query = "DELETE FROM " . $dbconfig["bookmarks_table"] . " WHERE username = '" . $login["username"] . "'";
		TWIGDebug( $query );
	        $result = dbQuery( $query );
		}

	$groupmlist = TWIGGroupsMembership( $login["username"] );
	$groupolist = TWIGGroupsOwnership( $login["username"] );

	TWIGDebug( "Enumerating group membership..." );
	foreach( $groupmlist as $gid )
		{
		$groupnamelist[TWIGGroupsGetName( $gid )] = "TRUE";
		}

	TWIGDebug( "Enumerating group ownership..." );
	foreach( $groupolist as $gid )
		{
		$groupnamelist[TWIGGroupsGetName( $gid )] = "TRUE";
		}

	foreach( $records as $data )
		{
		$cp = $data["parent"];
		$cg = $data["name"];
	
		while( $cp != "root" )
			{
			if( $cp != "root" )
				{
				$cg = $cp . $groupsep . $cg; 
				}

			$cp = $records[$cp]["parent"];
			}

		if( $groupnamelist[$cg] != "TRUE" AND $cg != "" AND $cg != "Unfiled" )
			{
			TWIGDebug( "TWIGGroupsCreateGroup( \"" . $login["username"] . "\", \"" . $login["username"] . "\", \"" . SQLString( $cg ) . "\" )" );
			TWIGGroupsCreateGroup( $login["username"], $login["username"], SQLString( $cg ) );
			}

		for( $i = 0; $i < $data["itemcount"]; $i++ )
			{
			BMAddRecord( $data[$i], $cg, $overwrite );
			}
		}
	}
	
?>

