<?php	// TWIG		PostGreSQL Functions

 Function TWIGProcessSQLString( $string )
	{
	global $config;

	if( !$config["GMQRUN"] ) { $config["GMQRUN"] = get_magic_quotes_runtime() + 1; }

	if( $config["GMQRUN"] == 2 )
		{
		return stripslashes( $string );
		}
	else
		{
		return $string;
		}
	}

 Function SQLString( $string ) 
	{
  	$string = addslashes( $string );
  
	return $string;
 	}

 Function createSqlDate( $year, $month, $day ) 
	{
   	return sprintf( "%04d-%02d-%02d", $year, $month, $day);
 	}

 Function createSqlDateTime( $year, $month, $day, $hour, $min, $sec ) 
	{
   	return sprintf( "%04d-%02d-%02d %02d:%02d:%02d", $year, $month, $day, $hour, $min, $sec );
 	}

 Function convertUTimetoSQLTime( $utime )
	{
	$fields = explode( " ", date( "Y m d H i s", $utime ) );

   	return createSqlDateTime( $fields[0], $fields[1], $fields[2], $fields[3], $fields[4], $fields[5] );
	}

 Function convertSQLTimetoUTime( $sqldate ) 
	{
   	return( mktime( substr( $sqldate, 11, 2 ), substr( $sqldate, 14, 2 ), substr( $sqldate, 17, 2 ), substr( $sqldate, 5, 2 ), substr( $sqldate, 8, 2 ), substr( $sqldate, 0, 4 ) ) );
 	}

 Function MakeInsertString( $data ) 
	{
  	while( list( $key, $val ) = each( $data ) ) 
		{
    		if( $val != "--remove" ) 
			{
      			$string["fields"] .= "\"" . $key . "\", ";
      			$string["values"] .= "'" . SQLString( $val ) . "', ";
    			}
  		}

  	$string["fields"] = ereg_replace( ", $", "", $string["fields"] );
  	$string["values"] = ereg_replace( ", $", "", $string["values"] );

  	return $string;
 	}

 Function MakeUpdateString( $data ) 
	{
  	while( list( $key, $val ) = each( $data ) ) 
		{
    		$temp[] = "\"" . $key . "\" = '". SQLString( $val ) . "'";
   		}

  	$strings .= implode( ", ", $temp );

  	return $strings;
 	}

 Function dbQuery( $statement ) 
	{
  	global $dbconfig;

  	if( $dbconfig["sqlserver"] != "" ) 
		{
   		$conn = "host=" . $dbconfig["sqlserver"];
  		}

  	if( $dbconfig["sqlport"] != "" ) 
		{
   		$conn = $conn . " port=" . $dbconfig["sqlport"];
  		}

  	if( $dbconfig["sqlusername"] != "" ) 
		{ 
   		$conn = $conn . " user=" . $dbconfig["sqlusername"]; 
  		}

  	if( $dbconfig["sqlpassword"] != "" ) 
		{ 
   		$conn = $conn . " password=" . $dbconfig["sqlpassword"]; 
  		} 

  	if( $dbconfig["defaultdb"] != "" ) 
		{ 
   		$conn = $conn . " dbname=" . $dbconfig["defaultdb"]; 
  		} 

  	$db = pg_pConnect( $conn );

  	if( !$db ) 
		{
    		TWIGPrintError( "Could not connect to database" );

    		return 0;
  		}

  	$result = pg_Exec( $db, $statement );

  	if( !$result ) 
		{
    		TWIGPrintError( pg_ErrorMessage( $db ) );
    		TWIGPrintError( $statement );
    		}

  	return $result;
 	}

 Function dbResult( $result, $i, $field ) 
	{
  	return pg_Result( $result, $i, $field );
 	}

 Function dbNumRows( $result ) 
	{
  	if( !$result ) { return ""; }

  	return pg_NumRows( $result );
 	}

 Function dbResultArray( $result, $i) 
	{
  	if (!$result) { return ""; }
  
	return pg_Fetch_Array( $result, $i );
 	}

 Function dbLastInsertID( $result, $table )
 	{
  	if( !$result ) { return ""; }
  	if( !$table ) { return ""; }

	$oid = pg_getlastoid( $result );
	$sql = "SELECT id FROM " . $table . " WHERE oid = '" . $oid . "'";
	$res = dbQuery( $sql );
	if( $res )
		{
		$row = dbResultArray( $res, 0 );
		return $row["id"];
		}
	else
		{
		return "";
		}
	}

 Function dbStoreBLOB( $table, $id, $field, $blob )
 	{
	$sql = "UPDATE $table SET $field = '" . addslashes( $blob ) . "' WHERE id = '$id'";
	$res = dbQuery( $sql );
	return $res;
	}

 Function dbRetrieveBLOB( $table, $id, $field, $blob = "" )
 	{
	$sql = "SELECT $field FROM $table WHERE id = '$id'";
	$res = dbQuery( $sql );
	if( dbNumRows( $res ) == 1 )
		{
		$ret = dbResultArray( $res, 0 );
		return $ret[$field];
		}
	elseif( dbNumRows( $res ) < 1 )
		{
   		TWIGPrintError( "dbRetrieveBLOB: no rows found matching id '$id' in table '$table'" );
		}
	elseif( dbNumrows( $res ) > 1 )
		{
   		TWIGPrintError( "dbRetrieveBLOB: id '$id' was not unique in table '$table'" );
		}
	return FALSE;
	}

?>
