<?php

$pagetitle = $TWIGphrase["TWIG [Schedule]"];
$session["listfeature"] = "schedule";

require( "features/shared/newlists.inc.php3" );

if( $schcurYear && $schcurMonth && $schcurDay ) { $session["schcurdate"] = mktime( 0, 0, 0, $schcurMonth, $schcurDay, $schcurYear ); }
if( !$session["schtodaysdate"] ) { $session["schtodaysdate"] = mktime(); }
if( !$session["schcurdate"] ) { $session["schcurdate"] = $session["schtodaysdate"]; }

$TWIGScheduleDate = array( "year"=>date( "Y", $session["schcurdate"] ), "month"=>date( "m", $session["schcurdate"] ), "day"=>date( "d", $session["schcurdate"] ) );
$TWIGScheduleToday = array( "year"=>date( "Y", $session["schtodaysdate"] ), "month"=>date( "m", $session["schtodaysdate"] ), "day"=>date( "d", $session["schtodaysdate"] ) );

// Figure out the last day of the month
$lastday[1]=31;
// Check for Leap Years
if( checkdate( 2, 29, date( "Y", $session["schcurdate"] ) ) ) { $lastday[2] = 29; }
else { $lastday[2]=28; }
$lastday[3]=31;
$lastday[4]=30;
$lastday[5]=31;
$lastday[6]=30;
$lastday[7]=31;
$lastday[8]=31;
$lastday[9]=30;
$lastday[10]=31;
$lastday[11]=30;
$lastday[12]=31;

if( !$included["schedule.inc.php3"] )
	{
	Function TWIGScheduleGetRecurDayString( $days )
		{
		GLOBAL $dayNames;

		$edays = explode( "-", $days );

		$ret = "";
		$first = 1;

		for( $i = 0; $i <  7; $i++ )
			{
			if( $edays[$i] ) 
				{ 
				if( !$first ) { $ret .= ", "; }
				$ret .= $dayNames[$i]; 
				$first = 0;
				}
			}

		return $ret;
		}

 	Function TWIGScheduleNumSpaces( $s, $e, $slot ) 
		{
		GLOBAL $todaystart, $todayend;

  		$max = 48 - $slot;
		$stime = convertSQLTimetoUTime( $s );
 		$etime = convertSQLTimetoUTime( $e );

		if( $stime < $todaystart ) { $stime = $todaystart; }
		if( $etime > $todayend )   { $etime = $todayend; }

  		$spaces = min( $max, intval( 2 * ( ( $etime - $stime ) / 3600 ) ) ) + 1;
  
		return $spaces;
 		}

	Function TWIGScheduleMenu()
		{
		GLOBAL $config, $login, $session, $TWIGphrase, $featureprefix, $dbconfig, $TWIGScheduleToday;

		$ret  = "<table width=100% border=0>\n<tr>\n<td NOWRAP>\n";
		$ret .= TWIGGroupsSelector( $login["username"], $session[$featureprefix . "Group"] , "list");
		$ret .= "</td>\n<td align=right>\n";

		$i = 0;
		if( TWIGCheckACL( $login["username"], 7001, TWIGConvertAccess( "read" ) ) ) { $schedulemenu[$i] = array( "command" => "schedule", "desc" => $TWIGphrase["Add&nbsp;item"], "action" => "edit", "options" => "" . "&action=New", "target" => "", "image" => "compose.gif" ); $i++; }
		if( TWIGCheckACL( $login["username"], 7000, TWIGConvertAccess( "read" ) ) ) { $schedulemenu[$i] = array( "command" => "schedule", "desc" => $TWIGphrase["Daily&nbsp;view"], "action" => "day", "options" => "", "target" => "", "image" => "daily.gif" ); $i++; }
		if( TWIGCheckACL( $login["username"], 7003, TWIGConvertAccess( "read" ) ) ) { $schedulemenu[$i] = array( "command" => "schedule", "desc" => $TWIGphrase["Weekly&nbsp;view"], "action" => "week", "options" => "", "target" => "", "image" => "weekly.gif" ); $i++; }
		$schedulemenu[$i] = array( "command" => "schedule", "desc" => $TWIGphrase["Monthly&nbsp;view"], "action" => "main", "options" => "", "target" => "", "image" => "monthly.gif" ); $i++;
		if( TWIGCheckACL( $login["username"], 7005, TWIGConvertAccess( "read" ) ) ) { $schedulemenu[$i] = array( "command" => "schedule", "desc" => $TWIGphrase["Calendar"], "action" => "month", "options" => "", "target" => "", "image" => "calendar.gif" ); $i++; }
		if( TWIGCheckACL( $login["username"], 7007, TWIGConvertAccess( "read" ) ) ) { $schedulemenu[$i] = array( "command" => "schedule", "desc" => $TWIGphrase["Yearly&nbsp;view"], "action" => "year", "options" => "", "target" => "", "image" => "year.gif" ); $i++; }
		if( TWIGCheckACL( $login["username"], 7004, TWIGConvertAccess( "read" ) ) ) { $schedulemenu[$i] = array( "command" => "schedule", "desc" => $TWIGphrase["List&nbsp;view"], "action" => "list", "options" => "", "target" => "", "image" => "list.gif" ); $i++; }
		$schedulemenu[$i] = array( "command" => "schedule", "desc" => $TWIGphrase["Go to today"], "action" => "", "options" => "schcurYear=" . $TWIGScheduleToday["year"] . "&schcurMonth=" . $TWIGScheduleToday["month"] . "&schcurDay=" . $TWIGScheduleToday["day"], "target" => "", "image" => "today.gif" ); $i++;
		if( TWIGCheckACL( $login["username"], 7006, TWIGConvertAccess( "read" ) ) ) { $schedulemenu[$i] = array( "command" => "schedule", "desc" => $TWIGphrase["Maintenance"], "action" => "maint", "options" => "", "target" => "", "image" => "maintenance.gif" ); $i++; }
		if( TWIGCheckACL( $login["username"], 7002, TWIGConvertAccess( "read" ) ) ) { $schedulemenu[$i] = array( "command" => "schedule", "desc" => $TWIGphrase["Prefs"], "action" => "prefs", "options"=>"", "target" => "", "image" => "prefs.gif" ); $i++; }

      		$ret .= TWIGGenerateMenu( $schedulemenu, GetPref( "mstyle2", $dbconfig["global_prefs_table"], $config["defaults"]["global"]["mstyle2"] ), "schedule" );

   		$ret .= "</font>\n</td>\n</tr>\n</table>\n" . $config["hr"] . "\n";

		$ret .= "<table border=0 width=100%>\n<tr>\n<td align=center>\n";
   		$ret .= "<font face=\"" . $config["cellfont"] . "\" size=" . $config["textfontsize"] . ">";
   		$ret .= $TWIGphrase["Today is"] . " " . TWIGdate( $config["longdateformat"], mktime() );
   		$ret .= "</font>\n</td>\n</tr>\n</table>\n" . $config["hr"] . "\n";

		return $ret;		
		}

	Function TWIGScheduleGetRecurringEntries( $edata, $rdata, $starttime, $stoptime, $subcall = 0 )
		{
		GLOBAL $lastday;

		TWIGDebug( "TWIGScheduleGetRecurringEntries( array, array, \"" . $starttime . "\", \"" . $stoptime . "\" );", 10 );

		$entries = array();
		$enum = 0;

		if( $edata["recurtype"] == 1 )
			{
			// If we have an entry that stops on a given date and that date is before $stoptime, reset $stoptime
			$rendtime = convertSQLTimeToUTime( $rdata["end"] ) + 86400;
			if( $rdata["endtype"] == 1 && $rendtime < $stoptime ) { $stoptime = $rendtime; }

			// If we've stopped before we've started, bail...
			if( $stoptime < $starttime ) { return $entries; }

			// calculate the number of days between our start and stop times, usefull later on
			$daydiff = intval( ( $starttime - $stoptime ) / 86400 );
		
			// calculate our item start and stop times and build an array of h/m/s/m/d/y based upon them, usefull later on
			$itemstart = convertSQLTimeToUtime( $edata["itemstart"] );
			$itemstop  = convertSQLTimeToUtime( $edata["itemstop"] ) ;
			$itemstartarray = explode( " ", date( "H i s n j Y", $itemstart ) );
			$itemstoparray  = explode( " ", date( "H i s n j Y", $itemstop  ) );

			// calculate the number of days/weeks/months/years since the item started recurring, usefull later on
			$dayssincestart = intval( ( $starttime - $itemstart ) / 86400 );
			if( $dayssincestart < 1 ) { $dayssincestart = 0; }
			$weekssincestart = intval( $dayssincestart / 7 );
			$yearssincestart = date( "Y", $starttime ) - date( "Y", $itemstart );

			if( $yearssincestart == 0 ) 
				{ 
				$monthssincestart = date( "n", $starttime ) - date( "n", $itemstart ); 
				} 
			else
				{
				$monthssincestart = ( 12 - date( "n", $itemstart ) ) + ( 12 * ( $yearssincestart - 1 ) ) + ( date( "n", $starttime ) );
				}

			// If the orignal event is within start time to stop time then add an entry for it
			if( $itemstart >= $starttime && $itemstart < $stoptime && !$subcall ) { $entries[$enum] = $edata; $enum++; }

			if( !isset( $rdata["recurtype"] ) ) { return $entries; }

			switch( $rdata["recurtype"] )
				{
				case 1:		// Every Monday to Firday
					$cdate = $dayssincestart * 86400;

					$tstart = convertSQLTimeToUTime( $edata["itemstart"] ) + $cdate;
					$tend = convertSQLTimeToUTime( $edata["itemstop"] ) + $cdate;

					while( $tstart < $stoptime )
						{
						$wday = date( "w", $tstart );

						if( $wday > 0 && $wday < 6 && $tstart >= $starttime )
							{
							$edata["itemstart"] = convertUTimeToSQLTime( $tstart );
							$edata["itemstop"]  = convertUTimeToSQLTime( $tend );

							$entries[$enum] = $edata;
							$enum++;
							}

						$tstart += 86400;
						$tend += 86400;
						}

					break;
				case 2:		// Every x weeks on y days
					$swdays = explode( "-", $rdata["days"] );

					$thisweek = intval( ( date( "z", $itemstart ) / 7 ) + 1 );
					$startdayofweek = ( date( "w", $itemstart ) + $dayssincestart ) % 7;

					$startweek = intval( ( date( "z", convertSQLTimeToUTime( $edata["itemstart"] ) ) / 7 ) + 1 );

					if( ( $thisweek - $startweek ) % $rdata["schedule"] == 0 )
						{
						$tstart = convertSQLTimeToUTime( $edata["itemstart"] ) + ( 86400 * ( $dayssincestart ) );
						$tend = convertSQLTimeToUTime( $edata["itemstop"] ) + ( 86400 * ( $dayssincestart ) );

						for( $i = $startdayofweek; $i < 7; $i++ )
							{
							if( $swdays[$i] == 1 && $tstart <= $stoptime && $tstart >= $starttime )
								{
								$edata["itemstart"] = convertUTimeToSQLTime( $tstart );
								$edata["itemstop"]  = convertUTimeToSQLTime( $tend );
		
								$entries[$enum] = $edata;
								$enum++;
								}

							$tstart += 86400;
							$tend += 86400;
							}
						}

					while( $tstart < $stoptime )
						{
						$thisweek++;

						if( ( $thisweek - $startweek ) % $rdata["schedule"] == 0 )
							{
							for( $i = 0; $i < 7; $i++ )
								{
								if( $swdays[$i] == 1 && $tstart < $stoptime )
									{
									$edata["itemstart"] = convertUTimeToSQLTime( $tstart );
									$edata["itemstop"]  = convertUTimeToSQLTime( $tend );
				
									$entries[$enum] = $edata;
									$enum++;
									}
		
								$tstart += 86400;
								$tend += 86400;
								}
							}
						else
							{
							$tstart += 86400 * 7;
							$tend += 86400 * 7;
							}
						}

					break;
				case 3:		// day x every y months
					$starttimearray = explode( " ", date( "H i s n j Y", $starttime ) );
					$stoptimearray  = explode( " ", date( "H i s n j Y", $stoptime  ) );
					
					$currentstartmonth = $starttimearray[3];
					$currentstopmonth = $stoptimearray[3];

					$tstart = mktime( $itemstartarray[0], $itemstartarray[1], $itemstartarray[2], $currentstartmonth, $rdata["schedule"], $starttimearray[5] );
					$tend = mktime( $itemstoparray[0], $itemstoparray[1], $itemstoparray[2], $currentstartmonth, $rdata["schedule"], $starttimearray[5] );

					while( $tstart <= $stoptime )
						{
						if( $tstart >= $itemstart && $tstart >= $starttime )
							{
							$cyears = date( "Y", $tstart ) - date( "Y", $itemstart );
							if( $cyears == 0 ) 
								{ 
								$cmonths = date( "n", $tstart ) - date( "n", $itemstart ); 
								} 
							else
								{
								$cmonths = ( 12 - date( "n", $tstart ) ) + ( 12 * ( $cyears - 1 ) ) + ( date( "n", $tstart ) );
								}
							
							if( $cmonths % $rdata["cycle"] == 0 )
								{
								$edata["itemstart"] = convertUTimeToSQLTime( $tstart );
								$edata["itemstop"]  = convertUTimeToSQLTime( $tend );
				
								$entries[$enum] = $edata;
								$enum++;
								}
							}

						$currentstartmonth++;
						$currentstopmonth++;

						$tstart = mktime( $itemstartarray[0], $itemstartarray[1], $itemstartarray[2], $currentstartmonth, $rdata["schedule"], $starttimearray[5] );
						$tend = mktime( $itemstoparray[0], $itemstoparray[1], $itemstoparray[2], $currentstartmonth, $rdata["schedule"], $stoptimearray[5] );
						}

					break;
				case 4:		// Every [first/second/third/forth/last] [day/weekday/weekend/S-S] of every [x] months
						//	 ["position"]			 ["cycle"]			    ["schedule"]
					$starttimearray = explode( " ", date( "H i s n j Y", $starttime ) );
					$stoptimearray  = explode( " ", date( "H i s n j Y", $stoptime  ) );

					switch( $rdata["cycle"] )
						{
						case 1:
							$starttimearray[3] +=  ( $monthssincestart % $rdata["schedule"] );
							while( $starttimearray[3] > 12 ) 
								{ 
								$starttimearray[5]++; 
								$starttimearray[3] -= 12; 
								}

							$tstart = $starttime;

							while( $tstart <= $stoptime && $tstart >= $starttime )
								{
								if( $rdata["position"] < 5 )
									{
									$mstart = mktime( 0, 0, 0, $starttimearray[3], 1, $starttimearray[5] );
							
									$wday = date( "w", $mstart ); 
									while( $wday == 0 || $wday == 6 )
										{
										$mstart += 86400;
										$wday = date( "w", $mstart );
										}

									$mstart += ( 86400 * ( $rdata["position"] - 1 ) );
									}
								else
									{
									$mstart = mktime( 0, 0, 0, $starttimearray[3], $lastday[$starttimearray[3]], $starttimearray[5] );
							
									$wday = date( "w", $mstart ); 
									while( $wday == 0 || $wday == 6 )
										{
										$mstart -= 86400;
										$wday = date( "w", $mstart );
										}
									}

								$mstartarray = explode( " ", date( "H i s n j Y", $mstart ) );

								$tstart = mktime( $itemstartarray[0], $itemstartarry[1], $itemstartarray[2], $mstartarray[3], $mstartarray[4], $mstartarray[5] );

								if( $tstart <= $stoptime && $tstart >= $starttime )
									{
									$edata["itemstart"] = convertUTimeToSQLTime( $tstart );
									$edata["itemstop"]  = convertUTimeToSQLTime( mktime( $itemstoparray[0], $itemstoparry[1], $itemstoparray[2], $mstartarray[3], $mstartarray[4], $mstartarray[5] ) );
			  
									$entries[$enum] = $edata;
									$enum++;
									}

								$starttimearray[3] += $rdata["schedule"];
								if( $starttimearray[3] > 12 ) { $starttimearray[5]++; $starttimearray[3] -= 12; }
								}

							break;
						case 2:
							$starttimearray[3] += ( $monthssincestart % $rdata["schedule"] );
							while( $starttimearray[3] > 12 ) 
								{ 
								$starttimearray[5]++; 
								$starttimearray[3] -= 12; 
								}

							$tstart = $starttime;

							while( $tstart <= $stoptime && $tstart >= $starttime )
								{
								if( $rdata["position"] < 5 )
									{
									$mstart = mktime( 0, 0, 0, $starttimearray[3], 1, $starttimearray[5] );
							
									$wday = date( "w", $mstart ); 
									while( $wday != 0 && $wday != 6 )
										{
										$mstart += 86400;
										$wday = date( "w", $mstart );
										}

									$mstart += ( ( 86400 * 7 ) * ( $rdata["position"] - 1 ) );
									}
								else
									{
									$mstart = mktime( 0, 0, 0, $starttimearray[3], $lastday[$starttimearray[3]], $starttimearray[5] );
							
									$wday = date( "w", $mstart ); 
									while( $wday != 0 && $wday != 6 )
										{
										$mstart -= 86400;
										$wday = date( "w", $mstart );
										}

									$mstart -= 86400;
									}

								$mstartarray = explode( " ", date( "H i s n j Y", $mstart ) );

								$tstart = mktime( $itemstartarray[0], $itemstartarry[1], $itemstartarray[2], $mstartarray[3], $mstartarray[4], $mstartarray[5] );

								if( $tstart <= $stoptime && $tstart >= $starttime )
									{
									$edata["itemstart"] = convertUTimeToSQLTime( $tstart );
									$edata["itemstop"]  = convertUTimeToSQLTime( mktime( $itemstoparray[0], $itemstoparry[1], $itemstoparray[2], $mstartarray[3], $mstartarray[4], $mstartarray[5] ) );
			  
									$entries[$enum] = $edata;
									$enum++;
									}

								$starttimearray[3] += $rdata["schedule"];
								if( $starttimearray[3] > 12 ) { $starttimearray[5]++; $starttimearray[3] -= 12; }
								}

							break;
						case 3:
						case 4:
						case 5:
						case 6:
						case 7:
						case 8:
						case 9:
							$rdata["cycle"] -= 3;

							$starttimearray[3] +=  ( $monthssincestart % $rdata["schedule"] );
							while( $starttimearray[3] > 12 ) 
								{ 
								$starttimearray[5]++; 
								$starttimearray[3] -= 12; 
								}

							$tstart = $starttime;

							while( $tstart <= $stoptime && $tstart >= $starttime )
								{
								if( $rdata["position"] < 5 )
									{
									$mstart = mktime( 0, 0, 0, $starttimearray[3], 1, $starttimearray[5] );
							
									$wday = date( "w", $mstart ); 
									while( $wday != $rdata["cycle"] )
										{
										$mstart += 86400;
										$wday = date( "w", $mstart );
										}

									$mstart += ( ( 86400 * 7 ) * ( $rdata["position"] - 1 ) );
									}
								else
									{
									$mstart = mktime( 0, 0, 0, $starttimearray[3], $lastday[$starttimearray[3]], $starttimearray[5] );
							
									$wday = date( "w", $mstart ); 
									while( $wday != $rdata["cycle"] )
										{
										$mstart -= 86400;
										$wday = date( "w", $mstart );
										}
									}

								$mstartarray = explode( " ", date( "H i s n j Y", $mstart ) );

								$tstart = mktime( $itemstartarray[0], $itemstartarry[1], $itemstartarray[2], $mstartarray[3], $mstartarray[4], $mstartarray[5] );
															
								if( $tstart <= $stoptime && $tstart >= $starttime )
									{
									$edata["itemstart"] = convertUTimeToSQLTime( $tstart );
									$edata["itemstop"]  = convertUTimeToSQLTime( mktime( $itemstoparray[0], $itemstoparry[1], $itemstoparray[2], $mstartarray[3], $mstartarray[4], $mstartarray[5] ) );
			  
									$entries[$enum] = $edata;
									$enum++;
									}

								$starttimearray[3] += $rdata["schedule"];
								if( $starttimearray[3] > 12 ) { $starttimearray[5]++; $starttimearray[3] -= 12; }
								}

							break;
						default:
							$rdata["recurtype"] = 3;

							if( $rdata["position"] == 5 ) 
								{ 
								$rdata["cycle"] = $lastday[$rdata["position"]]; 
								} 
							else 
								{ 
								$rdata["cycle"] = $rdata["position"];

								if( $rdata["cycle"] == 0 ) { $rdata["cycle"]++; }
								}

							$tentries = TWIGScheduleGetRecurringEntries( $edata, $rdata, $starttime, $stoptime, 1 );

							break;
						}

					if( is_array( $tentries[0] ) ) 
						{ 
						for( $i = 0, $j = count( $tentries ); $i < $j; $i++ )
							{
							$entries[$enum] = $tentries[$i];
							$enum++;
							}
						}

					break;
				case 5:		// Every day x in month y every year 
					$starttimearray = explode( " ", date( "H i s n j Y", $starttime ) );
					$stoptimearray  = explode( " ", date( "H i s n j Y", $stoptime  ) );

					$currentstartyear = $starttimearray[5];
					$currentstopyear = $stoptimearray[5];

					$tstart = mktime( $itemstartarray[0], $itemstartarray[1], $itemstartarray[2], $rdata["schedule"], $rdata["cycle"], $currentstartyear );
					$tend = mktime( $itemstoparray[0], $itemstoparray[1], $itemstoparray[2], $rdata["schedule"], $rdata["cycle"], $currentstartyear );

					while( $tstart <= $stoptime )
						{
						if( $tstart >= $itemstart && $tstart >= $starttime )
							{
							$edata["itemstart"] = convertUTimeToSQLTime( $tstart );
							$edata["itemstop"]  = convertUTimeToSQLTime( $tend );

							$entries[$enum] = $edata;
							$enum++;
							}

						$currentstartyear++;
						$currentstopyear++;

						$tstart = mktime( $itemstartarray[0], $itemstartarray[1], $itemstartarray[2], $rdata["schedule"], $rdata["cycle"], $currentstartyear );
						$tend = mktime( $itemstoparray[0], $itemstoparray[1], $itemstoparray[2], $rdata["schedule"], $rdata["cycle"], $currentstartyear );
						}
					break;
				case 6:		// Every [first/second/third/forth/last] [day/weekday/weekend/S-S] of every [month]
						//	 ["position"]			 ["cycle"]			    ["schedule"]
					$starttimearray = explode( " ", date( "H i s n j Y", $starttime ) );
					$stoptimearray  = explode( " ", date( "H i s n j Y", $stoptime  ) );

					switch( $rdata["cycle"] )
						{
						case 1:
							if( $rdata["position"] < 5 )
								{
								$mstart = mktime( 0, 0, 0, $rdata["schedule"], 1, $starttimearray[5] );
						
								$wday = date( "w", $mstart ); 
								while( $wday == 0 || $wday == 6 )
									{
									$mstart += 86400;
									$wday = date( "w", $mstart );
									}

								$mstart += ( 86400 * ( $rdata["position"] - 1 ) );
								}
							else
								{
								$mstart = mktime( 0, 0, 0, $rdata["schedule"], $lastday[$rdata["schedule"]], $starttimearray[5] );
						
								$wday = date( "w", $mstart ); 
								while( $wday == 0 || $wday == 6 )
									{
									$mstart -= 86400;
									$wday = date( "w", $mstart );
									}
								}

							$mstartarray = explode( " ", date( "H i s n j Y", $mstart ) );

							$tstart = mktime( $itemstartarray[0], $itemstartarry[1], $itemstartarray[2], $mstartarray[3], $mstartarray[4], $mstartarray[5] );
														
							if( $tstart <= $stoptime && $tstart >= $starttime )
								{
								$edata["itemstart"] = convertUTimeToSQLTime( $tstart );
								$edata["itemstop"]  = convertUTimeToSQLTime( mktime( $itemstoparray[0], $itemstoparry[1], $itemstoparray[2], $mstartarray[3], $mstartarray[4], $mstartarray[5] ) );
		  
								$entries[$enum] = $edata;
								$enum++;
								}
							break;
						case 2:
							if( $rdata["position"] < 5 )
								{
								$mstart = mktime( 0, 0, 0, $rdata["schedule"], 1, $starttimearray[5] );
						
								$wday = date( "w", $mstart ); 
								while( $wday != 0 && $wday != 6 )
									{
									$mstart += 86400;
									$wday = date( "w", $mstart );
									}

								$mstart += ( ( 86400 * 7 ) * ( $rdata["position"] - 1 ) );
								}
							else
								{
								$mstart = mktime( 0, 0, 0, $rdata["schedule"], $lastday[$rdata["schedule"]], $starttimearray[5] );
						
								$wday = date( "w", $mstart ); 
								while( $wday != 0 && $wday != 6 )
									{
									$mstart -= 86400;
									$wday = date( "w", $mstart );
									}

								$mstart -= 86400;
								}

							$mstartarray = explode( " ", date( "H i s n j Y", $mstart ) );

							$tstart = mktime( $itemstartarray[0], $itemstartarry[1], $itemstartarray[2], $mstartarray[3], $mstartarray[4], $mstartarray[5] );
														
							if( $tstart <= $stoptime && $tstart >= $starttime )
								{
								$edata["itemstart"] = convertUTimeToSQLTime( $tstart );
								$edata["itemstop"]  = convertUTimeToSQLTime( mktime( $itemstoparray[0], $itemstoparry[1], $itemstoparray[2], $mstartarray[3], $mstartarray[4], $mstartarray[5] ) );
		  
								$entries[$enum] = $edata;
								$enum++;
								}
							break;
						case 3:
						case 4:
						case 5:
						case 6:
						case 7:
						case 8:
						case 9:
							$rdata["cycle"] -= 3;

							if( $rdata["position"] < 5 )
								{
								$mstart = mktime( 0, 0, 0, $rdata["schedule"], 1, $starttimearray[5] );
						
								$wday = date( "w", $mstart ); 
								while( $wday != $rdata["cycle"] )
									{
									$mstart += 86400;
									$wday = date( "w", $mstart );
									}

								$mstart += ( ( 86400 * 7 ) * ( $rdata["position"] - 1 ) );
								}
							else
								{
								$mstart = mktime( 0, 0, 0, $rdata["schedule"], $lastday[$rdata["schedule"]], $starttimearray[5] );
						
								$wday = date( "w", $mstart ); 
								while( $wday != $rdata["cycle"] )
									{
									$mstart -= 86400;
									$wday = date( "w", $mstart );
									}
								}

							$mstartarray = explode( " ", date( "H i s n j Y", $mstart ) );

							$tstart = mktime( $itemstartarray[0], $itemstartarry[1], $itemstartarray[2], $mstartarray[3], $mstartarray[4], $mstartarray[5] );
														
							if( $tstart <= $stoptime && $tstart >= $starttime )
								{
								$edata["itemstart"] = convertUTimeToSQLTime( $tstart );
								$edata["itemstop"]  = convertUTimeToSQLTime( mktime( $itemstoparray[0], $itemstoparry[1], $itemstoparray[2], $mstartarray[3], $mstartarray[4], $mstartarray[5] ) );
		  
								$entries[$enum] = $edata;
								$enum++;
								}
							break;
						default:
							$rdata["recurtype"] = 5;

							TWIGDebug( $rdata["cycle"], 5 );
							if( $rdata["position"] == 5 ) 
								{ 
								$rdata["cycle"] = $lastday[$rdata["position"]]; 
								} 
							else 
								{ 
								$rdata["cycle"] = $rdata["position"];

								if( $rdata["cycle"] == 0 ) { $rdata["cycle"]++; }
								}

							$tentries = TWIGScheduleGetRecurringEntries( $edata, $rdata, $starttime, $stoptime, 1 );

							break;
						}

					if( is_array( $tentries[0] ) ) 
						{ 
						for( $i = 0, $j = count( $tentries ); $i < $j; $i++ )
							{
							$entries[$enum] = $tentries[$i];
							$enum++;
							}
						}

					break;
				default:	// Every X days
					$firstoccur = $dayssincestart + ( $dayssincestart % $rdata["schedule"] );
					$cdate = $firstoccur * 86400;

					$tstart = convertSQLTimeToUTime( $edata["itemstart"] ) + $cdate;
					$tend = convertSQLTimeToUTime( $edata["itemstop"] ) + $cdate;

					while( $tstart < $stoptime )
  						{
						if( $tstart > $starttime )
							{
							$edata["itemstart"] = convertUTimeToSQLTime( $tstart );
							$edata["itemstop"]  = convertUTimeToSQLTime( $tend );
    
  							$entries[$enum] = $edata;
  							$enum++;
							}
    
						$tstart += ( 86400 * $rdata["schedule"] );
						$tend += ( 86400 * $rdata["schedule"] );
						}

					break;
				}
			}

		return $entries;
		}

	Function TWIGScheduleGetItems( $starttime, $stoptime )
		{
		GLOBAL $config, $dbconfig, $groupquery;

		TWIGDebug( "TWIGScheduleGetItems( \"" . $starttime . "\", \"" . $stoptime . "\" );" );

		// First retreive the traditional no-recurring items
		$query = "SELECT * FROM " . $dbconfig["schedule_table"] . " WHERE (" . $groupquery . ") AND ( ( itemstart > '" . convertUTimeToSQLTime( $starttime ) . "' AND itemstart < '" . convertUTimeToSQLTime( $stoptime ) . "' ) OR ( itemstart < '" . convertUTimeToSQLTime( $starttime ) . "' AND itemstop > '" . convertUTimeToSQLTime( $stoptime ) . "' ) OR ( itemstop > '" . convertUTimeToSQLTime( $starttime ) . "' AND itemstop < '" . convertUTimeToSQLTime( $stoptime ) . "' ) ) AND ( recurtype = '0' ) ORDER BY itemstart";
		$result = dbQuery( $query );

		$nostartSlot = array();
		$startSlot = array();
		$allSlot = array();

		$allindex = 0;
		$sindex = 0;
		$nsindex = 0;

		for( $i = 0, $j = dbNumRows( $result ); $i < $j; $i++ ) 
			{
			$allSlot[$allindex] = dbResultArray( $result, $i );

			if( $allSlot[$allindex]["notime"] )
				{
				$nostartSlot[$nsindex] = $allSlot[$allindex];
				$nsindex++;
				}
			else
				{
				$startSlot[$sindex] = $allSlot[$allindex]; 
				$sindex++;
				}

			$allindex++;
			}

		// Second lets get the recurring items
		$query = "SELECT * FROM " . $dbconfig["schedule_table"] . " WHERE (" . $groupquery . ") AND itemstart <= '" . convertUTimeToSQLTime( $stoptime ) . "' AND ( recurtype = '1' ) ORDER BY itemstart";
		$result = dbQuery( $query );

		for( $i = 0, $j = dbNumRows( $result ); $i < $j; $i++ ) 
			{
			$recitems[$i]["data"] = dbResultArray( $result, $i );

			$rdquery = "SELECT * FROM " . $dbconfig["schedule_recurring_table"] . " WHERE id='" . $recitems[$i]["data"]["recurid"] . "'";
			$rdresult = dbQuery( $rdquery );

			$recitems[$i]["rddata"] = dbResultArray( $rdresult, 0 );
			}

		for( $i = 0, $j = count( $recitems ); $i < $j; $i++ )
			{
			$entries = TWIGScheduleGetRecurringEntries( $recitems[$i]["data"], $recitems[$i]["rddata"], $starttime, $stoptime );

			for( $k = 0, $l = count( $entries ); $k < $l; $k++, $m++ )
				{
				$allSlot[$allindex] = $entries[$k];

				if( $allSlot[$m]["notime"] )
					{
					$nostartSlot[$nsindex] = $allSlot[$allindex];
					$nsindex++;
					}
				else
					{
					$startSlot[$sindex] = $allSlot[$allindex]; 
					$sindex++;
					}

				$allindex++;
				}
			}

		$ret[0] = $allSlot;
		$ret[1] = $startSlot;
		$ret[2] = $nostartSlot;

		return $ret;
		}

	$included["schedule.inc.php3"] = 1;
	}

?>
