//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include <assert.h>
#include "SpanningTreeSelection.h"
#include <tulip/BooleanProperty.h>
#include <tulip/MethodFactory.h>
#include <tulip/GraphTools.h>

BOOLEANPLUGIN(SpanningTreeSelection,"Spanning Forest","David Auber","01/12/1999","Alpha","1.0");

using namespace std;
using namespace tlp;

SpanningTreeSelection::SpanningTreeSelection(const PropertyContext &context):BooleanAlgorithm(context) 
{}

SpanningTreeSelection::~SpanningTreeSelection() {}

///===========================================================
///Calcul l'arbre couvrant
bool SpanningTreeSelection::run()
{
  if (graph->existProperty("viewSelection")) {
    BooleanProperty *viewSelection=graph->getProperty<BooleanProperty>("viewSelection");
    Iterator<node> *itN=graph->getNodes();
    for (;itN->hasNext();) { 
      node itn=itN->next();
      if (viewSelection->getNodeValue(itn)==true) {
	booleanResult->setNodeValue(itn, true);
      }
    } delete itN;
  }

  selectSpanningForest(graph, booleanResult, pluginProgress); 
  return true;
}
