//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef DOXYGEN_NOTFOR_DEVEL
#ifndef _TLPSTLFUNCTIONS_H
#define _TLPSTLFUNCTIONS_H

namespace tlp {

class DoubleProperty;
class node;
class edge;
/**
   This class enables to compare nodes and edges according to a metric,
   instances of this class are useful for using stl sort function.
 */
class LessByMetric {
 public:
  LessByMetric(DoubleProperty *metric):metric(metric){}
  bool operator() (node n1,node n2);
  bool operator() (edge e1,edge e2);
private:
  DoubleProperty *metric;
};

}
#endif
#endif // DOXYGEN_NOTFOR_DEVEL
