//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef GL_HCVXHULL_H
#define GL_HCVXHULL_H

#include <tulip/Graph.h>

#include "tulip/GlLayer.h"

namespace tlp {

  class GlComposite;
  class ConvexHullItem;
  class GlConvexHull;

  /**
   * Build a hierarchy of convex hulls
   */
  class TLP_GL_SCOPE GlHierarchyConvexHulls {

  public:
    /**
     * Basic constructor
     */
    GlHierarchyConvexHulls(bool fatherHullsIsDeducedFromChilds = true) {
      deducedFromChilds = fatherHullsIsDeducedFromChilds;
    }
    virtual ~GlHierarchyConvexHulls() {}

    /**
     * Build the hierarchy for the given graph in GlLayer
     */
    virtual void compute(tlp::GlLayer*,tlp::Graph *);

    /**
     * Create the hierarchy of ConvexHullItem
     */
    ConvexHullItem *buildComposite(ConvexHullItem *convexHull, GlConvexHull *oldHull);
    void setToOld(ConvexHullItem *convexHull, GlConvexHull *oldHull);

    bool deducedFromChilds;
  };
}

#endif
