// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef VEC_INC
#define VEC_INC

#include "Object.h"
#include "Vec.h"

namespace Torch {

/** Vector object.
    
    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class Vec : public Object
{
  public:
  
    /** #false# if #ptr# is not allocated by Vec.
        (With the first constructor)
    */
    bool ptr_is_allocated;

    /// Size of the vector
    int n;

    /// Data of the vector
    real *ptr;

    /** Create a vector from values in #ptr_#.
        (No memory copy).
    */
    Vec(real * ptr_, int n_dim);

    /// Create a new vector
    Vec(int n_dim);

    /// Copy the vector #vec# starting from index #start_i#
    void copy(Vec * vec, int start_i = 0);

    /// Zero the matrix
    void zero();

    /// Compute the norm1
    real norm1(Vec * weights = NULL);

    /// Compute the norm2
    real norm2(Vec * weights = NULL);

    /// Compute the norm inf
    real normInf();

    /// Inner product of two vectors from #start_i# downwards
    real iP(Vec * vec, int start_i = 0);

    /** Return a sub-vector.
        Note that the memory is shared with the original
        vector, so *be carefull*.
    */
    Vec *subVec(int dim1, int dim2);

    ~Vec();
};


}

#endif
