// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SOFTMAX_INC
#define SOFTMAX_INC

#include "GradientMachine.h"

namespace Torch {

/** Softmax layer for #GradientMachine#.

    The number of inputs/outputs is the number
    of units in the machine.

    Formally speaking, $ouputs[i] = 1/a * exp(inputs[i]-shift)$
    where $a = \sum_j exp(inputs[j]-shift)$.

    Options:
    \begin{tabular}{lcll}
      "shift"           & real &   shift to avoid overflow         & [0]\\
      "compute shift"   & bool &   compute shift to avoid overflow & [false]
    \end{tabular}

    (you can have the "shift" you want, if you want, or
    you can automatically compute the shift)

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class Softmax : public GradientMachine
{
  public:
    real shift;
    bool calc_shift;

    //-----

    /// Create a Sigmoid layer with #n_units# units.
    Softmax(int n_units);

    //-----

    virtual int numberOfParams();
    virtual void forward(List *inputs);
    virtual void backward(List *inputs, real *alpha);

    virtual ~Softmax();
};


}

#endif
