// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SATURATION_MEASURER_INC
#define SATURATION_MEASURER_INC

#include "Measurer.h"
#include "GradientMachine.h"

namespace Torch {

/** Measure the saturation of a #GradientMachine#.

    Save in #file# (on two columns)
      - the absolute mean of the outputs of the machine.
      - the absolute mean of the derivative of the parameters of the machine.

   #measure# = {<[real] mean of outputs> <[real] mean of gradients>
                <[real] current sum of ouputs> <[real] current sum of gradients>}

   @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class SaturationMeasurer : public Measurer
{
  public:
    real *sum_outputs;
    real *sum_outputs_c;
    real n_sum_out;
    real *sum_derivees;
    real *sum_derivees_c;
    real n_sum_der;

    GradientMachine *machine;

    //-----

    ///
    SaturationMeasurer(GradientMachine *machine_, DataSet *data_, FILE *file_);
    ///
    SaturationMeasurer(GradientMachine *machine_, DataSet *data_, const char *filename);

    //-----

    virtual void init();
    virtual void reset();
    virtual void measureEx();
    virtual void measureIter();

    virtual ~SaturationMeasurer();
};


}

#endif
