// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef OPTIMIZER_INC
#define OPTIMIZER_INC

#include "Object.h"
#include "GradientMachine.h"
#include "DataSet.h"
#include "Criterion.h"

namespace Torch {

/** Optimizer for the #GMTrainer# class.

    Given a #criterion#, a #machine# (#GradientMachine#)
    and a #DataSet# #data#, it optimizes the #machine#
    with respect to the #criterion# on the #data#.

    @author Ronan Collobert (collober@iro.umontreal.ca)
    @see GMTrainer
*/
class Optimizer : public Object
{
  public:
    GradientMachine *machine;
    DataSet *data;
    Criterion *criterion;

    //-----

    ///
    Optimizer();

    /** Optimize.
        The measurers #measurers# will be called
        during the optimization.
    */
    virtual void train(List *measurers) = 0;

    /** Set the #machine#.
        This method could be called at every time
        before a call to #train()#.
    */
    void setMachine(GradientMachine *machine_);

    /** Set the #data#.
        This method could be called at every time
        before a call to #train()#.
    */
    void setDataSet(DataSet *data_);

    /** Set the #criterion#.
        This method could be called at every time
        before a call to #train()#.
    */
    void setCriterion(Criterion *criterion_);

    //-----

    virtual ~Optimizer();
};


}

#endif
