// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "MseMeasurer.h"

namespace Torch {

MseMeasurer::MseMeasurer(List *inputs_, DataSet *data_, FILE *file_) : Measurer(data_, file_)
{
  inputs = inputs_;
  measure = xalloc(sizeof(real)*2);

  real *r_measure = (real *)measure;
  erreur = r_measure;
  erreur_c = r_measure+1;

  *erreur = 0;

  reset();
}

MseMeasurer::MseMeasurer(List *inputs_, DataSet *data_, const char *filename) : Measurer(data_, filename)
{
  inputs = inputs_;
  measure = xalloc(sizeof(real)*2);

  real *r_measure = (real *)measure;
  erreur = r_measure;
  erreur_c = r_measure+1;

  *erreur = 0;
  
  reset();
}

void MseMeasurer::measureEx()
{
  real *des = (real *)data->targets;

  List *inputs_ = inputs;
  while(inputs_)
  {
    real *out = (real *)inputs_->ptr;
    for(int i = 0; i < inputs_->n; i++)
    {
      real z = *out++ - *des++;
      *erreur_c += z*z;
    }
    inputs_ = inputs_->next;
  }
}

void MseMeasurer::measureIter()
{
  *erreur = *erreur_c / ((real)data->n_examples);

  fprintf(file, "%g\n", *erreur);
  fflush(file);
  reset();
}

void MseMeasurer::init()
{
  Measurer::init();
  reset();
}

void MseMeasurer::reset()
{
  *erreur_c = 0;
}

MseMeasurer::~MseMeasurer()
{
  free(measure);
}


}

