// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "NllMeasurer.h"

namespace Torch {

NllMeasurer::NllMeasurer(List *inputs_, SeqDataSet *data_, FILE *file_) : Measurer(data_, file_)
{
  inputs = inputs_;
  sdata = data_;
  measure = xalloc(sizeof(real)*2);

  real *r_measure = (real *)measure;
  erreur = r_measure;
  erreur_c = r_measure+1;

  *erreur = 0;
  tot_n_frames = 0;

  reset();
}

NllMeasurer::NllMeasurer(List *inputs_, SeqDataSet *data_, const char *filename) : Measurer(data_, filename)
{
  inputs = inputs_;
  sdata = data_;
  measure = xalloc(sizeof(real)*2);

  real *r_measure = (real *)measure;
  erreur = r_measure;
  erreur_c = r_measure+1;

  *erreur = 0;
  tot_n_frames = 0;
  
  reset();
}

void NllMeasurer::measureEx()
{
  *erreur_c += *(real*)inputs->ptr;
  tot_n_frames += sdata->n_frames;
}

void NllMeasurer::measureIter()
{
  *erreur = *erreur_c / ((real)tot_n_frames);

  fprintf(file, "%g\n", *erreur);
  fflush(file);
  reset();
}

void NllMeasurer::init()
{
  Measurer::init();
  reset();
}

void NllMeasurer::reset()
{
  *erreur_c = 0;
  tot_n_frames = 0;
}

NllMeasurer::~NllMeasurer()
{
  if(measure){
   free(measure);
   measure = NULL;
  }
}


}

