// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include "FixedMachineDistribution.h"

namespace Torch {

FixedMachineDistribution::FixedMachineDistribution(Machine* machine_,int output_number_,real prior_) : Distribution()
{
  machine = machine_;
  output_number = output_number_;
  prior = prior_;

  n_observations = machine->n_inputs;
  n_inputs = 0;

  machine_inputs.next = NULL;
  machine_inputs.n = n_observations;
}

int FixedMachineDistribution::numberOfParams()
{
  return 0;
}

void FixedMachineDistribution::reset()
{
  machine->reset();
}

real FixedMachineDistribution::frameLogProbability(real *observations, real *inputs, int t)
{
  machine_inputs.ptr = observations;
  // this is not very optimal as each state of the HMM will call this 
  // method... a better solution would be to modify the HMM code itself...
  // but I have not found a clean way to do it yet.
  machine->forward(&machine_inputs);
  real res = 0;
  int i = output_number;
  List* out = machine->outputs;
  while (out) {
    if (i < out->n) {
      res = ((real*)out->ptr)[i];
      break;
    }
    i -= out->n;
    out = out->next;
  }
  return log(res / prior);
}

FixedMachineDistribution::~FixedMachineDistribution()
{
}

}

