-- Topal: GPG/GnuPG and Alpine/Pine integration
-- Copyright (C) 2001--2008  Phillip J. Brooke
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License version 3 as
-- published by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

package Receiving is

   -- We want to verify or decrypt a message.
   procedure Display (Tmpfile : in String);

   -- We want to verify or decrypt an RFC2015 MIME message.
   procedure Mime_Display (Infile       : in String;
                           Content_Type : in String);

   -- Handle the deprecated application/pgp content-type.
   procedure Mime_Display_APGP (Infile       : in String;
                                Content_Type : in String);
   
   -- Eat an entire email from stdin.
   procedure Process_Stdin;

end Receiving;
