namespace eval shellbar {
    # No private variables
}

proc shellbar::create { w } {
    global tkWorld

    # Create the GUI components for the shell, working directory
    # drop down list boxes, and the background process indicator.
    frame $w \
	    -class Shellbar

    set wd_label [label $w.label_wd \
	    -text "Dir" \
	    -anchor w]
    set wd_entry [entry $w.entry_wd \
	    -width 50 \
	    -textvariable tkWorld(working_dir)]
    set tkWorld(working_dir_entry) $wd_entry
    set dir_button [button $w.button_dir \
	    -text "dir" \
	    -width 1 \
	    -relief flat \
	    -command [list wdir::contents::list dir]]
    set ls_button [button $w.button_ls \
	    -text "ls" \
	    -width 1 \
	    -relief flat \
	    -command [list wdir::contents::list ls]]
    set cd_button [button $w.button_cd \
	    -text "cd" \
	    -width 1 \
	    -relief flat \
	    -command wdir::create]
    pack $dir_button $ls_button $cd_button $wd_entry \
	    -side left \
	    -padx 0 \
	    -pady 0
    pack [seperator::create $w.sep2 sunken] \
	    -side left \
	    -padx 5 \
	    -pady 0 \
	    -fill y
    set shell_label [label $w.shell_label \
	    -text "Shell"]
    set shell_entry [ddlistbox::create $w tkWorld(working_shell) \
	    "sh bash ksh pdksh csh tcsh ash zsh" 5]
    pack $shell_label $shell_entry \
	    -side left \
	    -padx 2 \
	    -pady 0
    pack [seperator::create $w.sep1 sunken] \
	    -side left \
	    -padx 5 \
	    -pady 0 \
	    -fill y
    set bg_checkbutton [checkbutton $w.bg_checkbutton \
	    -text "Background" \
	    -variable cmd_center::cmd_center(bg_user_request)]
    pack $bg_checkbutton \
	    -side left \
	    -padx 2 \
	    -pady 0 \
	    -fill x

    # Make the buttons raise and lower on mouse entry/leave.
    bind $dir_button <Enter> "$dir_button configure -relief raised"
    bind $dir_button <Leave> "$dir_button configure -relief flat"
    bind $ls_button <Enter> "$ls_button configure -relief raised"
    bind $ls_button <Leave> "$ls_button configure -relief flat"
    bind $cd_button <Enter> "$cd_button configure -relief raised"
    bind $cd_button <Leave> "$cd_button configure -relief flat"

    # Define the balloon help messages for the executing shell and
    # the working directory components.
    balloonhelp::for $shell_label "Execute commands using this shell"
    balloonhelp::for $shell_entry "Change the executing shell"
    balloonhelp::for $wd_label "The current working directory"
    balloonhelp::for $wd_entry "The current working directory"
    balloonhelp::for $dir_button "Display the directory listing for\
	    the current working directory"
    balloonhelp::for $ls_button "Display the long format listing for\
	    the current working directory"
    balloonhelp::for $cd_button "Open the Change Working Directory\
	    Dialog to select a new working directory"
    balloonhelp::for $bg_checkbutton "Execute the current command\
	    in the background"
}