# $Id: idefault.tcl,v 1.3 2004/04/04 19:00:38 aleksey Exp $

switch -exact -- $::tcl_platform(platform) {
    "unix" {
	# We don't use named font because of insufficient flexibility of font
	# selection in Tk (for example, you can't select -slant oblique or
	# -weight semicondensed)
	# Also font encoding can't be specified
        set font "fixed"
    }
    "windows" {
        set font [font create font -family "Arial" -size 10]
    }
    default {
        set font [font create font -family "fixed" -size 10]
    }
}

set default_font [list [font actual $font -family] [font actual $font -size]]

proc define_fonts {args} {
    global font font_bold font_italic font_bold_italic

    if {$::tcl_platform(platform) == "unix"} {
	if {![info exists font_bold]} {
	    set font_bold [eval font create [font actual $font]]
	    font configure $font_bold -weight bold
	}
	if {![info exists font_italic]} {
	    set font_italic [eval font create [font actual $font]]
	    font configure $font_italic -slant italic
	}
	if {![info exists font_bold_italic]} {
	    set font_bold_italic [eval font create [font actual $font]]
	    font configure $font_bold_italic -weight bold -slant italic
	}
    } else {
	if {[catch {
	    set font_bold \
		[eval font create font_bold [font actual $font]]
	    set font_italic \
		[eval font create font_italic [font actual $font]]
	    set font_bold_italic \
		[eval font create font_bold_italic [font actual $font]]
	}]} {
	    eval font configure font_bold [font actual $font]
	    eval font configure font_italic [font actual $font]
	    eval font configure font_bold_italic [font actual $font]
	}
	font configure font_italic -slant italic
	font configure font_bold -weight bold
	font configure font_bold_italic -weight bold -slant italic
    }
}

hook::add postload_hook [namespace current]::define_fonts 70

if {![info exists usetabbar]} {
    set usetabbar 1
}
if {![info exists pixmaps_theme]} {
    set pixmaps_theme default
}

if {$::tcl_platform(platform) == "unix"} {
    option add *Entry.font $::font widgetDefault
} else {
    #font create menufont -family Helvetica -size 10 \
    # -weight normal -slant roman -underline 0 -overstrike 0
    eval [linsert [font configure $font] 0 font create menufont]

    option add *font menufont widgetDefault
    option add *Entry.font font widgetDefault
}

