# $Id: custom.tcl,v 1.18 2004/04/23 20:27:35 aleksey Exp $

option add *Customize.varforeground       blue widgetDefault
option add *Customize.groupnameforeground blue widgetDefault

namespace eval custom {
    set options(customfile) [file join ~ .tkabber custom.tcl]
}

proc custom::defgroup {id doc args} {
    variable group

    if {![info exists group(members,$id)]} {
	set group(members,$id) {}
    }
    if {![info exists group(subgroups,$id)]} {
	set group(subgroups,$id) {}
    }
    set group(doc,$id) $doc
    set group(tag,$id) $id
    if {![info exists group(parents,$id)]} {
	set group(parents,$id) {}
    }

    foreach {attr val} $args {
	switch -- $attr {
	    -tag {set group(tag,$id) $val}
	    -group {
		lappend group(subgroups,$val) [list group $id]
		lappend group(parents,$id) $val
		#set group(members,$val) [lrmdups $group(members,$val)]
	    }
	    -type {
		set group(type,$id) $val
	    }
	}
    }
}


proc custom::defvar {vname value doc args} {
    variable var
    variable group

    set fullname [uplevel 1 {namespace current}]::$vname

    if {![info exists $fullname]} {
	set $fullname $value
    }

    set var(default,$fullname) $value
    set var(doc,$fullname) $doc
    set var(type,$fullname) string
    set var(state,$fullname) ""

    foreach {attr val} $args {
	switch -- $attr {
	    -type {set var(type,$fullname) $val}
	    -group {
		lappend group(members,$val) [list var $fullname]
		#set group(members,$val) [lrmdups $group(members,$val)]
	    }
	    -command {
		trace variable $fullname w $val
	    }
	    -values {
		set var(values,$fullname) $val
	    }
	    -layout {
		set var(layout,$fullname) $val
	    }
	}
    }
}

custom::defgroup Tkabber \
    [::msgcat::mc "Customization of the One True Jabber Client."] \

custom::defgroup Hidden "Hidden group" -group Tkabber -tag "Hidden group" \
    -type hidden

###############################################################################

proc custom::open_window {gid} {
    global font

    set w .customize
    if {[winfo exists $w]} {
	return
    }

    add_win $w -title [::msgcat::mc "Customize"] \
	-tabtitle [::msgcat::mc "Customize"] \
	-class Customize
	#-raisecmd "focus [list $w.input]"


    set sw [ScrolledWindow $w.sw]
    set t [text $w.fields -wrap word -background [$w cget -background]]
    $sw setwidget $t


    frame $w.navigate
    button $w.navigate.back -text <- \
	-command [list [namespace current]::history_move 1]
    button $w.navigate.forward -text -> \
	-command [list [namespace current]::history_move -1]
    button $w.navigate.toplevel -text Tkabber \
	-command [list [namespace current]::goto Tkabber]
    label $w.navigate.lab -text [::msgcat::mc "Group:"]
    Entry $w.navigate.entry -textvariable [namespace current]::curgroup \
	-command [list [namespace current]::go]
    button $w.navigate.browse -text [::msgcat::mc "Open"] \
	-command [list [namespace current]::go]

    pack $w.navigate.back $w.navigate.forward \
	$w.navigate.toplevel $w.navigate.lab -side left
    pack $w.navigate.entry -side left -expand yes -fill x
    pack $w.navigate.browse -side left
    pack $w.navigate -side top -fill x


    pack $sw -side top -fill both -expand yes


    $t tag configure var -underline no \
	-foreground [option get $w varforeground Customize]
    $t tag configure groupname -underline no \
	-foreground [option get $w groupnameforeground Customize]

    bind $t <Key-Down> [list $t yview scroll 1 unit]
    bind $t <Key-Up> [list $t yview scroll -1 unit]
    bind $t <Key-Next> [list $t yview scroll 1 page]
    bind $t <Key-Prior> [list $t yview scroll -1 page]

    variable history
    set history(pos) 0
    set history(list) {}

    variable curgroup $gid

    update idletasks
    goto $gid

    focus $t
}

proc custom::go {} {
    variable curgroup
    history_add $curgroup
    fill_group .customize.fields $curgroup
}

proc custom::goto {gid} {
    history_add $gid
    fill_group .customize.fields $gid
}

proc custom::fill_group {t gid} {
    variable group
    variable var
    variable curgroup

    set curgroup $gid

    $t configure -state normal

    $t delete 1.0 end

    if {![info exists group(members,$gid)]} {
	$t configure -state disabled
	return
    }

    set i 0

    if {[info exists group(parents,$gid)] && $group(parents,$gid) != {}} {
	if {[llength $group(parents,$gid)] == 1} {
	    $t insert end [::msgcat::mc "Parent group:"]
	} else {
	    $t insert end [::msgcat::mc "Parent groups:"]
	}
	foreach parent $group(parents,$gid) {
	    $t insert end " "
	    set b [button $t.gr$i -text $group(tag,$parent) \
		       -cursor left_ptr \
		       -command [list [namespace current]::goto $parent]]
	    $t window create end -window $b
	    
	    incr i
	}
	$t insert end "\n\n"
    }

    foreach member [concat $group(members,$gid) \
			[lsort -dictionary $group(subgroups,$gid)]] {
	lassign $member type data
	switch -- $type {
	    group {
		if {[info exists group(type,$data)] && \
			[cequal $group(type,$data) "hidden"]} {
		    continue
		}
		set b [button $t.gr$i -text [::msgcat::mc "Open"] \
			-cursor left_ptr \
			-command [list [namespace current]::goto $data]]
		$t window create end -window $b
		$t insert end " " {} $group(tag,$data) groupname "\n"

		$t insert end "$group(doc,$data)\n"

		bindtags $b [lreplace [bindtags $b] 1 0 $t]

		$t insert end "\n"
	    }
	    var {
		$t insert end $data var ": "
		
		fill_var $t $data $i

		$t insert end "\n"

	    }
	}
	incr i
    }

    $t configure -state disabled
}

proc custom::fill_var {t varname idx} {
    variable var
    variable tmp

    switch -- $var(type,$varname) {
	string {
	    catch {unset tmp($varname)}
	    trace variable [namespace current]::tmp($varname) w \
		[list [namespace current]::on_edit $varname]
	    set tmp($varname) [set $varname]
	    set e [entry $t.entry$idx \
		       -textvariable [namespace current]::tmp($varname)]
	    $t window create end -window $e
	    $t insert end "\n"
	}

	password {
	    catch {unset tmp($varname)}
	    trace variable [namespace current]::tmp($varname) w \
		[list [namespace current]::on_edit $varname]
	    set tmp($varname) [set $varname]
	    set e [entry $t.entry$idx -show * \
		       -textvariable [namespace current]::tmp($varname)]
	    $t window create end -window $e
	    $t insert end "\n"
	}

	boolean {
	    catch {unset tmp($varname)}
	    trace variable [namespace current]::tmp($varname) w \
		[list [namespace current]::on_edit $varname]
	    set tmp($varname) [set $varname]
	    set cb [checkbutton $t.cb$idx -cursor left_ptr \
			-variable [namespace current]::tmp($varname)]
	    $t window create end -window $cb
	    $t insert end "\n"
	}

	integer {
	    catch {unset tmp($varname)}
	    trace variable [namespace current]::tmp($varname) w \
		[list [namespace current]::on_edit $varname]
	    set tmp($varname) [set $varname]
	    set e [Spinbox $t.spin$idx -1000000000 1000000000 1 [namespace current]::tmp($varname)]
	    $t window create end -window $e
	    $t insert end "\n"
	}

	list {
	    if {![info exists var(values,$varname)]} return

	    catch {unset tmp($varname)}
	    trace variable [namespace current]::tmp($varname) w \
		[list [namespace current]::on_edit $varname]
	    set tmp($varname) [set $varname]
	    set fr [frame $t.fr$idx -cursor left_ptr]
	    trace variable [namespace current]::tmp($varname) w \
		[list [namespace current]::on_change $fr.lb $varname]
	    set sw [ScrolledWindow $fr.sw]
	    set lb [listbox $fr.lb -cursor left_ptr \
			-selectmode extended -height 3 -exportselection false]
	    eval [list $lb] insert end $var(values,$varname)
	    $sw setwidget $lb
	    pack $sw
	    foreach i $tmp($varname) {
		$lb selection set $i
	    }
	    bind $lb <<ListboxSelect>> \
		"set [namespace current]::tmp($varname) \[$lb curselection\]"
	    $t window create end -window $fr -align top
	    $t insert end "\n"
	}

	radio {
	    catch {unset tmp($varname)}
	    trace variable [namespace current]::tmp($varname) w \
		[list [namespace current]::on_edit $varname]
	    set tmp($varname) [set $varname]
	    if {[info exists var(layout,$varname)] && \
			[string first v $var(layout,$varname)] == 0} {
		set anchor w
		set side top
	    } else {
		set anchor n
		set side left
	    }
	    set fr [frame $t.fr$idx -cursor left_ptr]
	    set i 0
	    foreach {val displ} $var(values,$varname) {
		set rb [radiobutton $fr.rb$i -cursor left_ptr \
			    -text $displ -value $val \
			    -variable [namespace current]::tmp($varname)]
		pack $rb -anchor $anchor -side $side
		incr i
	    }
	    $t window create end -window $fr -align top
	    $t insert end "\n"
	}

	font {
	    catch {unset tmp($varname)}
	    trace variable [namespace current]::tmp($varname) w \
		[list [namespace current]::on_edit $varname]
	    set tmp($varname) [set $varname]
	    set fr [frame $t.fr$idx -cursor left_ptr]
	    trace variable [namespace current]::tmp($varname) w \
		[list [namespace current]::on_change $fr.selectfont $varname]
	    set sf [SelectFont $fr.selectfont -type toolbar \
			-font $tmp($varname) \
			-command [list [namespace current]::on_set_font \
				      $fr.selectfont $varname]]
	    pack $sf
	    $t window create end -window $fr
	    $t insert end "\n"
	}

	default {
	    $t insert end "\n"
	}
    }

    set b [menubutton $t.stb$idx -text [::msgcat::mc "State"] \
	       -cursor left_ptr \
	       -menu $t.stb$idx.statemenu -relief $::tk_relief]
    create_state_menu $b.statemenu $varname
    $t window create end -window $b
    set l [label $t.stl$idx \
	       -textvariable [namespace current]::var(state,$varname)]
    $t insert end " "
    $t window create end -window $l
    $t insert end "\n"

    $t insert end "$var(doc,$varname)\n"
}

proc custom::on_change {w varname args} {
    variable var
    variable tmp

    if {![winfo exists $w]} {
	return
    }

    switch -- $var(type,$varname) {
	font {
	    $w configure -font $tmp($varname)
	}
	list {
	    $w selection clear 0 end
	    foreach i $tmp($varname) {
		$w selection set $i
	    }
	}
    }
}

proc custom::on_set_font {sf varname} {
    variable tmp

    set tmp($varname) [$sf cget -font]
}

proc custom::on_edit {varname args} {
    variable var
    variable tmp
    variable saved

    set is_default [cequal [set $varname] $var(default,$varname)]
    set is_current [cequal [set $varname] $tmp($varname)]
    if {[info exists saved($varname)]} {
	set is_saved [cequal [set $varname] $saved($varname)]
    } else {	
	set is_saved -1
    }

    if {!$is_current} {
	set st [::msgcat::mc "you have edited the value, but you have not set the option."]
    } else {
	switch -glob -- $is_default,$is_saved {
	    1,1 -
	    1,-1 {set st [::msgcat::mc "this option is unchanged from its standard setting."]}
	    1,0 -
	    0,0 -
	    0,-1 {set st [::msgcat::mc "you have set this option, but not saved it for future sessions."]}
	    0,1 {set st [::msgcat::mc "this option has been set and saved."]}
	}
    }

    set var(state,$varname) $st
}


proc custom::create_state_menu {m varname} {
    if {[winfo exists $m]} {
	destroy $m
    }

    menu $m
    $m add command -label [::msgcat::mc "Set for Current Session"] \
	-command [list [namespace current]::set_for_current_sess $varname]
    $m add command -label [::msgcat::mc "Set for Future Sessions"] \
	-command [list [namespace current]::save_var $varname]
    $m add command -label [::msgcat::mc "Reset to Current"] \
	-command [list [namespace current]::reset_to_current $varname]
    $m add command -label [::msgcat::mc "Reset to Saved"] \
	-command [list [namespace current]::reset_to_saved $varname]
    $m add command -label [::msgcat::mc "Reset to Default"] \
	-command [list [namespace current]::reset_to_default $varname]

    return $m
}

proc custom::set_for_current_sess {varname} {
    variable var
    variable tmp
    variable saved

    set $varname $tmp($varname)

    on_edit $varname
}

proc custom::reset_to_current {varname} {
    variable var
    variable tmp
    variable saved

    set tmp($varname) [set $varname]

    on_edit $varname
}

proc custom::reset_to_saved {varname} {
    variable var
    variable tmp
    variable saved

    if {![info exists saved($varname)]} return

    set tmp($varname) $saved($varname)
    set $varname $saved($varname)

    on_edit $varname
}

proc custom::reset_to_default {varname} {
    variable var
    variable tmp
    variable saved

    set tmp($varname) $var(default,$varname)
    set $varname $var(default,$varname)

    on_edit $varname
}

proc custom::save_var {varname} {
    variable var
    variable tmp
    variable saved

    set saved($varname) $tmp($varname)
    set $varname $tmp($varname)

    store

    on_edit $varname
}

proc custom::store {} {
    variable var
    variable saved
    variable options

    set fd [open $options(customfile) w]
    fconfigure $fd -encoding utf-8

    foreach varname [array names saved] {
	if {![info exists var(default,$varname)] || \
		($saved($varname) != $var(default,$varname))} {
	    puts $fd [list [list $varname $saved($varname)]]
	}
    }

    close $fd
    catch {file attributes ~/.tkabber/custom.tcl -permissions 00600}
}

proc custom::restore {} {
    variable var
    variable saved
    variable options

    if {![file readable $options(customfile)]} return

    set fd [open $options(customfile) r]
    fconfigure $fd -encoding utf-8

    set opts [read $fd]
    close $fd

    foreach opt $opts {
	lassign $opt varname value

	set saved($varname) $value
	catch {set $varname $value}
    }
}
hook::add postload_hook custom::restore 60


proc custom::history_move {shift} {
    variable history
    variable curgroup

    set newpos [expr {$history(pos) + $shift}]

    if {$newpos < 0} {
	return
    }

    if {$newpos >= [llength $history(list)]} {
	return
    }

    set newgroup [lindex $history(list) $newpos]
    set history(pos) $newpos
    
    set curgroup $newgroup

    fill_group .customize.fields $newgroup
}


proc custom::history_add {gid} {
    variable history

    set history(list) [lreplace $history(list) 0 \
			   [expr {$history(pos) - 1}]]
    
    lvarpush history(list) $gid
    set history(pos) 0

    debugmsg custom [array get history]
}


