/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "FileUrlSelectDlg.H"
#include <wx/statline.h>

enum {
  BTN_OK = 1
};

BEGIN_EVENT_TABLE(UrlSelectDlg,wxDialog)
  EVT_BUTTON(BTN_OK, UrlSelectDlg::onButtonOK)
END_EVENT_TABLE()

UrlSelectDlg::UrlSelectDlg (wxWindow* parent, int id, bool can_be_empty)
  : wxDialog(parent,id,wxString(_("Select local or remote file...")),
	     wxDefaultPosition, wxDefaultSize,
	     wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER),
    can_be_empty(can_be_empty)
{
}

void UrlSelectDlg::init (UrlSelectPanel* urlPanel) {
  this->urlPanel=urlPanel;
  wxBoxSizer* dialogSizer = new wxBoxSizer(wxVERTICAL);
  dialogSizer->Add(urlPanel,1,wxEXPAND|wxALL,10);
  dialogSizer->Add(new wxStaticLine(this,-1),0,wxEXPAND|wxLEFT|wxRIGHT,10);
  dialogSizer->Add(getButtonSizer(this),0,
		   wxALIGN_CENTER_HORIZONTAL|wxALL,10);

  SetSizer(dialogSizer);
  dialogSizer->SetSizeHints(this);
  Centre();
}

wxSizer* UrlSelectDlg::getButtonSizer (wxWindow* parent) {
  wxBoxSizer* retval = new wxBoxSizer(wxHORIZONTAL);
  retval->Add(new wxButton(parent,BTN_OK,_("OK")));
  retval->Add(new wxButton(parent,wxID_CANCEL,_("Cancel")),
	      0,wxLEFT,10);
  return retval;
}

wxString UrlSelectDlg::getURLstr () {
  return this->urlPanel->getURLstr();
}

void UrlSelectDlg::onButtonOK (wxCommandEvent& WXUNUSED(e)) {
  if (this->urlPanel->allFieldsValid() || can_be_empty) {
    EndModal(wxID_OK);
    return;
  } else {
    wxMessageBox(_("You specified an invalid configuration for a file location."),
		 _("Important!"), wxOK|wxICON_INFORMATION|wxCENTRE, this);
  }
}

UrlFile* FileUrlSelectDlg::getURL () {
  return new UrlFile(this->getURLstr());
}

BinaryFileUrlSelectDlg::BinaryFileUrlSelectDlg (wxWindow* parent, int id,
						UrlFile defaultUrl,
						bool can_be_empty)
  : FileUrlSelectDlg(parent,id,can_be_empty)
{
  init(new BinaryFileUrlSelectPanel(this,-1,defaultUrl));
}

TextFileUrlSelectDlg::TextFileUrlSelectDlg (wxWindow* parent, int id,
					    UrlFile defaultUrl,
					    bool can_be_empty)
  : FileUrlSelectDlg(parent,id,can_be_empty)
{
  init(new TextFileUrlSelectPanel(this,-1,defaultUrl));
}

wxString TextFileUrlSelectDlg::getCharset () {
  return ((TextFileUrlSelectPanel*)urlPanel)->getCharset();
}

UrlFile* TextFileUrlSelectDlg::getURL () {
  UrlFile* retval = FileUrlSelectDlg::getURL();
  retval->setCharset(this->getCharset());
  return retval;
}
