/*  tilp - a linking program for TI graphing calculators
 *  Copyright (C) 1999-2002  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "struct.h"
#include "gstruct.h"
#include "defs.h"
#include "support.h"


/* Put sensitive some buttons of the toolbar according to some options */
void refresh_sensitive_toolbar_buttons()
{
  GtkToolbar *tb = GTK_TOOLBAR(toolbar_win.toolbar);
  GtkToolbarChild *child;
  GtkWidget *old_icon, *new_icon;
  GdkPixmap *pixmap;
  GdkBitmap *mask;

  /* Enable or disable some buttons */
  gtk_widget_set_sensitive(toolbar_win.button1, 
			   (ti_calc.supported_operations() & OPS_ISREADY));

  gtk_widget_set_sensitive(toolbar_win.button3, 
			   (ti_calc.supported_operations() & OPS_SCREENDUMP));
  
  gtk_widget_set_sensitive(toolbar_win.button4, 
			   (ti_calc.supported_operations() & OPS_DIRLIST));
  
  gtk_widget_set_sensitive(toolbar_win.button5, 
			   (ti_calc.supported_operations() & OPS_RECV_BACKUP));
  
  gtk_widget_set_sensitive(toolbar_win.button6, 
			   (ti_calc.supported_operations() & OPS_SEND_BACKUP));

  gtk_widget_set_sensitive(toolbar_win.button7, TRUE);

  /* Dynamically change the icon */
  child = g_list_nth(tb->children, 5)->data;
  old_icon = child->icon;

  if(clist_win.selection != NULL)
    new_icon = create_pixmap (toolbar_win.toolbar, "calc_send.xpm");
  else if(ctree_win.selection != NULL)
    new_icon = create_pixmap (toolbar_win.toolbar, "calc_recv.xpm");
  else
    new_icon = create_pixmap (toolbar_win.toolbar, "calc_send.xpm");

  gtk_pixmap_get(GTK_PIXMAP(new_icon), &pixmap, &mask);
  gtk_pixmap_set(GTK_PIXMAP(old_icon), pixmap, mask);

  return;
}




