#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "tifileinfo_cb.h"
#include "tifileinfo_dbox.h"
#include "support.h"

#include "tilibs.h"
#include "struct.h"
#include "msg_cb.h"

gint display_tifileinfo_dbox(gchar *filename)
{
  GtkWidget *dbox;
  gpointer user_data;
  gchar *str;
  gchar buffer[MAXCHARS];
  gchar *ti_filename;
  gint err=0;

#ifdef HAVE_LIBTIFFEP
  TiffepFileInfo *fi = NULL;
#endif

  ti_filename = g_strdup(filename);
  dbox = create_tifileinfo_dbox();

#ifdef HAVE_LIBTIFFEP
  if( (err = tiffep_load_file_informations(ti_filename, &fi)) != 0)
    return err;
  
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "tifileinfo_dbox");
  gtk_window_set_title (GTK_WINDOW(user_data), _("File informations"));
  
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "entry1");
  gtk_entry_set_text(GTK_ENTRY(user_data), FILEINFO_COMMENT(fi));

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "label6");
  str = g_strconcat("File name: ", FILEINFO_NAME(fi), NULL);
  gtk_label_set_text(GTK_LABEL(user_data), str);
  g_free(str);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "label7");
  if(FILEINFO_VARLIST(fi) == NULL)
    {
      msg_box(_("Error"),
	      _("Invalid TI file."));
      g_free(ti_filename);
      tiffep_free_fi_struct(&fi);
      return 0;
    }
  str = g_strconcat("Var name: ", VARINFO_REALNAME(VARLIST_DATA(FILEINFO_VARLIST(fi))), NULL);
  gtk_label_set_text(GTK_LABEL(user_data), str);
  g_free(str);     

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "label8");
  str = g_strconcat(_("Calc type: "), 
		    tiffep_calc_type_to_string(FILEINFO_CALCTYPE(fi)), NULL);
  gtk_label_set_text(GTK_LABEL(user_data), str);
  g_free(str);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "label9");
  str = g_strconcat("Var type: ", 
		    tiffep_var_type_to_string(VARINFO_TYPE(VARLIST_DATA(FILEINFO_VARLIST(fi)))), NULL);
  gtk_label_set_text(GTK_LABEL(user_data), str);
  g_free(str);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "label10");
  g_snprintf(buffer, MAXCHARS, "%i", FILEINFO_FILESIZE(fi));
  str = g_strconcat("File size: ", buffer, " bytes", NULL);
  gtk_label_set_text(GTK_LABEL(user_data), str);
  g_free(str);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "label11");
  str = g_strconcat("Var path: ", VARINFO_PATH(VARLIST_DATA(FILEINFO_VARLIST(fi))), NULL);
  gtk_label_set_text(GTK_LABEL(user_data), str);
  g_free(str);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "label12");
  g_snprintf(buffer, MAXCHARS, "%i", FILEINFO_DATASIZE(fi));
  str = g_strconcat("Data size: ", buffer, " bytes", NULL);
  gtk_label_set_text(GTK_LABEL(user_data), str);
  g_free(str);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "label13");
  g_snprintf(buffer, MAXCHARS, "%i", VARINFO_SIZE(VARLIST_DATA(FILEINFO_VARLIST(fi))));
  str = g_strconcat("Var size: ", buffer, " bytes", NULL);
  gtk_label_set_text(GTK_LABEL(user_data), str);
  g_free(str);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "label14");
  g_snprintf(buffer, MAXCHARS, "%i", FILEINFO_NUMVARS(fi));
  str = g_strconcat("Number of vars: ", buffer, NULL);
  gtk_label_set_text(GTK_LABEL(user_data), str);
  g_free(str);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "label15");
  str = g_strconcat("Var attrb: ", 
		    tiffep_attribute_to_string(VARINFO_ATTRIBUTE(VARLIST_DATA(FILEINFO_VARLIST(fi)))), NULL);
  gtk_label_set_text(GTK_LABEL(user_data), str);
  g_free(str);

  gtk_widget_show_all(dbox);
  g_free(ti_filename);
  tiffep_free_fi_struct(&fi);
#endif

  return 0;
}


void
on_tifileinfo_ok_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_tifileinfo_cancel_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}
