/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2009 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef PDBIO_SEEN
#define PDBIO_SEEN

#include "pdbMalloc.h"

int
ReadPDBCds(char *pdbfile_name, PDBCdsArray *pdbA, int cds_i, int modelnum, int fix_atom_names);

/* void */
/* XPLORcorrections(PDBCds *pdbcds, int record); */

void
GetCdsSelection(CdsArray *baseA, PDBCdsArray *pdbA);

CdsArray
*GetCdsSel(CdsArray *baseA, PDBCdsArray *pdbA);

/* CdsArray */
/* *GetDefaultCdsSel(CdsArray *baseA, PDBCdsArray *pdbA); */

/* static int */
/* atom_selxn(char *record, int mode); */

/* int */
/* range_selxn(int chainID, char *chains, int resSeq, int *lower, int *upper, int range_num); */

PDBCdsArray
*GetPDBCds(char **argv_array, int narguments, int fmodel, int fix_atom_names);

void
PrintCds(Cds *cds);

void
PrintPDBCds(FILE *pdbfile, PDBCds *pdbcds);

void
PrintCds2File(FILE *pdbfile, Cds *cds);

void
PrintOccPDBCds(FILE *pdbfile, PDBCds *pdbcds);

int
IsNameCAorP(char *name);

/* int */
/* ReadCds(char *pdbfile_name, CdsArray *cdsA, int cds_index, int modelnum); */

void
WriteModelFile(PDBCdsArray *pdbA, char *outfile_name);

void
WriteTheseusModelFile(PDBCdsArray *pdbA, Algorithm *algo, Statistics *stats, char *outfile_name);

void
WriteTheseusModelFileNoStats(PDBCdsArray *pdbA, Algorithm *algo, char *outfile_name);

void
WriteTheseusCdsModelFile(CdsArray *cdsA, char *outfile_name);

void
WriteTheseusPDBFiles(PDBCdsArray *pdbA, Algorithm *algo, Statistics *stats);

void
PrintTheseusModelHeader(FILE *pdbfile);

void
PrintModelFileStats(FILE *pdbfile, PDBCdsArray *pdbA, Algorithm *algo, Statistics *stats);

void
WriteOlveModelFile(PDBCdsArray *pdbA, Algorithm *algo, Statistics *stats, char *outfile_name);

void
WriteCdsFile(Cds *cds, char *outfile_name);

void
WritePDBCdsFile(PDBCds *cds, char *file_name);

void
WriteAveCdsFile(CdsArray *cdsA, char *outfile_name);

void
WriteAveCds(CdsArray *cdsA, char *outfile_name);

void
WriteAvePDBCdsFile(PDBCdsArray *pdbA, char *outfile_name);

void
WriteBinPDBCdsArray(PDBCdsArray *pdbA);

PDBCdsArray
*ReadBinPDBCdsArray(char *filename);

void
WriteBinPDBCds(PDBCds *pdbcds, FILE *fp);

void
ReadBinPDBCds(PDBCds *pdbcds, FILE *fp);

void
WriteBinMatrix(double **mat, int rows, int cols, FILE *fp);

void
ReadBinMatrix(double **mat, FILE *fp);

#endif
