/*

    File: file_djv.c

    Copyright (C) 2006 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 51
    Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include <stdio.h>
#include "types.h"
#include "photorec.h"

static const char* header_check_djv(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery);

const t_file_hint file_hint_djv= {
  .extension="djv",
  .description="DjVu",
  .min_header_distance=0,
  .min_filesize=8,
  .max_filesize=200*1024*1024,
  .recover=1,
  .header_check=&header_check_djv,
  .data_check=NULL,
  .file_check=NULL
};

static const char* header_check_djv(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery)
{
  const unsigned char djv_header[8]= { 'A','T','&','T','F','O','R','M'};
  if(memcmp(buffer,djv_header,sizeof(djv_header))==0)
    return file_hint_djv.extension;
  return NULL;
}
