package SCConfig;

#   $Id: SCConfig.pm,v 1.8 2002/02/13 16:38:34 sdague Exp $

#   Copyright (c) 2001 International Business Machines

#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
 
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
 
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#   Sean Dague <japh@us.ibm.com>

use strict;
use AppConfig qw(:expand :argcount);
use vars qw($VERSION);

$VERSION = sprintf("%d.%02d", q$Revision: 1.8 $ =~ /(\d+)\.(\d+)/);

my %cfg = (
           CASE => 0,
           CREATE => 1,
           GLOBAL => {
                      DEFAULT => undef,
                      ARGCOUNT => ARGCOUNT_ONE,
                     },
          );

my $config = new AppConfig(\%cfg,
                           CFGFILE => {
                                       DEFAULT => "",
                                      },
                           STDIN => {
                                     DEFAULT => 0,
                                     ARGCOUNT => ARGCOUNT_NONE,
                                    },
                           VERBOSE => {
                                       DEFAULT => 0,
                                       ARGCOUNT => ARGCOUNT_NONE,
                                      },
			   DEBUG => {
				       DEFAULT => 0,
				       ARGCOUNT => ARGCOUNT_NONE,
				      },
                           VERSION => {
                                       DEFAULT => 0,
                                       ARGCOUNT => ARGCOUNT_NONE,
                                      },
                           HELP => {
                                    DEFAULT => 0,
                                    ARGCOUNT => ARGCOUNT_NONE,
                                   },
                           CONFIGBOOT => {
                                          DEFAULT => 0,
                                          ARGCOUNT => ARGCOUNT_NONE,
                                         },
                           RUNBOOT => {
                                          DEFAULT => 0,
                                          ARGCOUNT => ARGCOUNT_NONE,
                                         },
                           CONFIGNET => {
                                         DEFAULT => 0,
                                         ARGCOUNT => ARGCOUNT_NONE,
                                        },
                           CONFIGHW => {
                                        DEFAULT => 0,
                                        ARGCOUNT => ARGCOUNT_NONE,
                                       },
                           CONFIGRD => {
                                             DEFAULT => 0,
                                             ARGCOUNT => ARGCOUNT_NONE,
                                            },
                           # Now we define macros that will be used for configuration
                           # CONFIGSI is for SystemImager:
                           # equivalent to --confignet --confighw --runboot

                           CONFIGSI => {
                                        DEFAULT => 0,
                                        ARGCOUNT => ARGCOUNT_NONE,
                                       },

                           # Turns on all options

                           CONFIGALL => {
                                         DEFAULT => 0,
                                         ARGCOUNT => ARGCOUNT_NONE,
                                        },
                           EXCLUDESTO => {
                                          DEFAULT => "",
                                         },
			   ROOT => {
				    DEFAULT => "",
				   },
                          );

# First we parse the config file
if(-e "/etc/systemconfig/systemconfig.conf") {
    $config->file("/etc/systemconfig/systemconfig.conf");
}    

$config->getopt();

my @args;

if($config->stdin()) {
    push @args, \*STDIN;
}

if($config->cfgfile && -e $config->cfgfile()) {
    push @args, $config->cfgfile();
}

if(scalar @args) {
    $config->file(@args);
}

if ($config->configsi) {
    $config->confignet(1);
    $config->confighw(1);
    $config->runboot(1);
}

if ($config->configall) {
    $config->confignet(1);
    $config->confighw(1);
    $config->configrd(1);
    $config->configboot(1);
    $config->runboot(1);
}

$::main::config = $config;

=head1 NAME 

SCConfig - AppConfig Macros for systemconfigurator

=head1 SYNOPSIS

  use SCConfig;
  use vars qw($config);

  my $var1 = $config->get('var1');

=head1 DESCRIPTION

SCConfig is just a central location to store all the AppConfig
setup used by the B<systemconfigurator> script.

Upon use, SCConfig parses command line arguments and config files.
It registers a global variable $config into the main name space which is an instance
of AppConfig.

=head1 AUTHORS

Sean Dague <japh@us.ibm.com>
Joe Greenseid <jgreenseid@users.sourceforge.net>
V Hoffman <greekboy@users.sourceforge.net>

=head1 SEE ALSO

L<AppConfig>, L<systemconfigurator>, L<systemconfig.conf>, L<perl>, and
the I<sample.cfg> config file in the systemconfigurator distribution.

=cut


1;
