
#ifndef _RWFILTERWINDOW_H_
#define _RWFILTERWINDOW_H_

#include <vector>
#include <string>

#include <WINGs/WINGs.h>
#include <WINGs/wtableview.h>

#include "rwwindow.h"

#include "rpackagefilter.h"

struct RFilter;
class RPackageLister;
class RWFilterEditor;

class RWFilterWindow;

typedef void RWFilterWindowCloseAction(void *self, RWFilterWindow *win);

typedef void RWFilterWindowSaveAction(void *self, RWFilterWindow *win);

class RWFilterWindow : public RWWindow
{
private:

   RPackageLister *_lister;
   RWFilterEditor *_editor;
   
   static void saveFilterAction(WMWidget *win, void *data);
   static void clearFilterAction(WMWidget *self, void *data);
   static void windowCloseAction(WMWidget *win, void *data);

   RWFilterWindowCloseAction *_closeAction;
   void *_closeObject;
   RWFilterWindowSaveAction *_saveAction;
   void *_saveObject;
   
public:
   RWFilterWindow(RWWindow *win, RPackageLister *lister);
   virtual ~RWFilterWindow();

   void editFilter(RFilter *filter);
   
   void setCloseCallback(RWFilterWindowCloseAction *action, void *data);
   void setSaveCallback(RWFilterWindowSaveAction *action, void *data);
};


#endif
