/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.IThemeElementDefinition;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeElementCategory;

public class ThemeRegistry
implements IThemeRegistry {
    private List themes = new ArrayList();
    private List colors = new ArrayList();
    private List fonts = new ArrayList();
    private List categories = new ArrayList();
    private Map dataMap = new HashMap();

    void add(IThemeDescriptor desc) {
        this.themes.add(desc);
    }

    void add(ColorDefinition desc) {
        this.colors.add(desc);
    }

    public ColorDefinition findColor(String id) {
        return (ColorDefinition)this.findDescriptor(this.getColors(), id);
    }

    public IThemeDescriptor findTheme(String id) {
        return (IThemeDescriptor)this.findDescriptor(this.getThemes(), id);
    }

    private IThemeElementDefinition findDescriptor(IThemeElementDefinition[] descriptors, String id) {
        int idx = Arrays.binarySearch(descriptors, id, IThemeRegistry.ID_COMPARATOR);
        if (idx < 0) {
            return null;
        }
        return descriptors[idx];
    }

    public IThemeDescriptor[] getThemes() {
        int nSize = this.themes.size();
        IThemeDescriptor[] retArray = new IThemeDescriptor[nSize];
        this.themes.toArray(retArray);
        Arrays.sort(retArray, IThemeRegistry.ID_COMPARATOR);
        return retArray;
    }

    public ColorDefinition[] getColors() {
        int nSize = this.colors.size();
        ColorDefinition[] retArray = new ColorDefinition[nSize];
        this.colors.toArray(retArray);
        Arrays.sort(retArray, IThemeRegistry.ID_COMPARATOR);
        return retArray;
    }

    void add(FontDefinition definition) {
        this.fonts.add(definition);
    }

    public FontDefinition[] getFonts() {
        int nSize = this.fonts.size();
        FontDefinition[] retArray = new FontDefinition[nSize];
        this.fonts.toArray(retArray);
        Arrays.sort(retArray, IThemeRegistry.ID_COMPARATOR);
        return retArray;
    }

    public FontDefinition findFont(String id) {
        return (FontDefinition)this.findDescriptor(this.getFonts(), id);
    }

    void add(ThemeElementCategory definition) {
        this.categories.add(definition);
    }

    public ThemeElementCategory[] getCategories() {
        int nSize = this.categories.size();
        ThemeElementCategory[] retArray = new ThemeElementCategory[nSize];
        this.categories.toArray(retArray);
        Arrays.sort(retArray, IThemeRegistry.ID_COMPARATOR);
        return retArray;
    }

    void setData(String name, String value) {
        this.dataMap.put(name, value);
    }

    public Map getData() {
        return Collections.unmodifiableMap(this.dataMap);
    }

    public void addData(Map otherData) {
        this.dataMap.putAll(otherData);
    }
}

