/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.undo;

import java.util.Iterator;
import java.util.Vector;
import swingwtx.swing.undo.AbstractUndoableEdit;
import swingwtx.swing.undo.CannotRedoException;
import swingwtx.swing.undo.CannotUndoException;
import swingwtx.swing.undo.UndoableEdit;

public class CompoundEdit
extends AbstractUndoableEdit {
    protected Vector edits = new Vector();
    private boolean inProgress = true;

    public boolean canUndo() {
        return !this.isInProgress() && super.canUndo();
    }

    public void undo() throws CannotUndoException {
        super.undo();
        for (int i = this.edits.size() - 1; i >= 0; --i) {
            ((UndoableEdit)this.edits.elementAt(i)).undo();
        }
    }

    public boolean canRedo() {
        return !this.isInProgress() && super.canRedo();
    }

    public void redo() throws CannotRedoException {
        super.redo();
        Iterator iterator = this.edits.iterator();
        while (iterator.hasNext()) {
            UndoableEdit undoableEdit = (UndoableEdit)iterator.next();
            undoableEdit.redo();
        }
    }

    protected UndoableEdit lastEdit() {
        return this.edits.size() > 0 ? (UndoableEdit)this.edits.lastElement() : null;
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public void end() {
        this.inProgress = false;
    }

    public void die() {
        Iterator iterator = this.edits.iterator();
        while (iterator.hasNext()) {
            UndoableEdit undoableEdit = (UndoableEdit)iterator.next();
            undoableEdit.die();
        }
        super.die();
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        boolean success = false;
        if (this.isInProgress()) {
            UndoableEdit lastEdit = this.lastEdit();
            success = true;
            if (this.edits.size() == 0) {
                this.edits.add(undoableEdit);
            } else if (!lastEdit.addEdit(undoableEdit)) {
                if (undoableEdit.replaceEdit(lastEdit)) {
                    this.edits.remove(this.edits.size() - 1);
                } else {
                    this.edits.add(undoableEdit);
                }
            }
        }
        return success;
    }

    public boolean isSignificant() {
        boolean isSignificant = false;
        Iterator iterator = this.edits.iterator();
        while (iterator.hasNext()) {
            UndoableEdit undoableEdit = (UndoableEdit)iterator.next();
            if (!undoableEdit.isSignificant()) continue;
            isSignificant = true;
            break;
        }
        return isSignificant;
    }

    public String getPresentationName() {
        UndoableEdit lastEdit = this.lastEdit();
        String presentationName = lastEdit == null ? super.getPresentationName() : lastEdit.getPresentationName();
        return presentationName;
    }

    public String getUndoPresentationName() {
        UndoableEdit lastEdit = this.lastEdit();
        if (lastEdit == null) {
            return super.getUndoPresentationName();
        }
        return lastEdit.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        UndoableEdit lastEdit = this.lastEdit();
        if (lastEdit == null) {
            return super.getUndoPresentationName();
        }
        return lastEdit.getUndoPresentationName();
    }
}

