/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt.font;

public class TextHitInfo {
    private int charIndex;
    private boolean isLeadingEdge;

    public static TextHitInfo leading(int charIndex) {
        return new TextHitInfo(charIndex, true);
    }

    public static TextHitInfo trailing(int charIndex) {
        return new TextHitInfo(charIndex, false);
    }

    public static TextHitInfo beforeOffset(int offset) {
        return new TextHitInfo(offset - 1, false);
    }

    public static TextHitInfo afterOffset(int offset) {
        return new TextHitInfo(offset, true);
    }

    private TextHitInfo(int charIndex, boolean isLeadingEdge) {
        this.charIndex = charIndex;
        this.isLeadingEdge = isLeadingEdge;
    }

    public TextHitInfo getOffsetHit(int delta) {
        return new TextHitInfo(this.charIndex + delta, this.isLeadingEdge);
    }

    public int getCharIndex() {
        return this.charIndex;
    }

    public boolean isLeadingEdge() {
        return this.isLeadingEdge;
    }

    public int getInsertionIndex() {
        int insertionIndex = this.charIndex;
        if (!this.isLeadingEdge) {
            ++insertionIndex;
        }
        return insertionIndex;
    }

    public TextHitInfo getOtherHit() {
        TextHitInfo textHitInfo = this.isLeadingEdge ? TextHitInfo.trailing(this.charIndex - 1) : TextHitInfo.leading(this.charIndex + 1);
        return textHitInfo;
    }

    public int hashCode() {
        return this.charIndex;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj != null && obj instanceof TextHitInfo && this.charIndex == ((TextHitInfo)obj).charIndex && this.isLeadingEdge == ((TextHitInfo)obj).isLeadingEdge) {
            equals = true;
        }
        return equals;
    }
}

