/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.AbstractTransferDragSourceListener;
import org.eclipse.gef.ui.parts.TreeViewerTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

class TreeViewerTransferDragListener
extends AbstractTransferDragSourceListener {
    private List modelSelection;

    public TreeViewerTransferDragListener(EditPartViewer viewer) {
        super(viewer, (Transfer)TreeViewerTransfer.getInstance());
    }

    public TreeViewerTransferDragListener(EditPartViewer viewer, Transfer xfer) {
        super(viewer, xfer);
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.getViewer().getSelectedEditParts();
    }

    public void dragStart(DragSourceEvent event) {
        TreeViewerTransfer.getInstance().setViewer(this.getViewer());
        List selection = this.getViewer().getSelectedEditParts();
        TreeViewerTransfer.getInstance().setObject(selection);
        this.saveModelSelection(selection);
    }

    public void dragFinished(DragSourceEvent event) {
        TreeViewerTransfer.getInstance().setObject(null);
        TreeViewerTransfer.getInstance().setViewer(null);
        this.revertModelSelection();
    }

    protected void revertModelSelection() {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < this.modelSelection.size()) {
            list.add(this.getViewer().getEditPartRegistry().get(this.modelSelection.get(i)));
            ++i;
        }
        this.getViewer().setSelection((ISelection)new StructuredSelection(list));
    }

    protected void saveModelSelection(List editPartSelection) {
        this.modelSelection = new ArrayList();
        int i = 0;
        while (i < editPartSelection.size()) {
            EditPart editpart = (EditPart)editPartSelection.get(i);
            this.modelSelection.add(editpart.getModel());
            ++i;
        }
    }
}

