/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.internal.jobs.JobChangeEvent;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;

class JobListeners {
    private final IListenerDoit aboutToRun = new IListenerDoit(){

        public void notify(IJobChangeListener listener, IJobChangeEvent event) {
            listener.aboutToRun(event);
        }
    };
    private final IListenerDoit awake = new IListenerDoit(){

        public void notify(IJobChangeListener listener, IJobChangeEvent event) {
            listener.awake(event);
        }
    };
    private final IListenerDoit done = new IListenerDoit(){

        public void notify(IJobChangeListener listener, IJobChangeEvent event) {
            listener.done(event);
        }
    };
    private final IListenerDoit running = new IListenerDoit(){

        public void notify(IJobChangeListener listener, IJobChangeEvent event) {
            listener.running(event);
        }
    };
    private final IListenerDoit scheduled = new IListenerDoit(){

        public void notify(IJobChangeListener listener, IJobChangeEvent event) {
            listener.scheduled(event);
        }
    };
    private final IListenerDoit sleeping = new IListenerDoit(){

        public void notify(IJobChangeListener listener, IJobChangeEvent event) {
            listener.sleeping(event);
        }
    };
    protected final List global = Collections.synchronizedList(new ArrayList());

    JobListeners() {
    }

    static JobChangeEvent newEvent(Job job) {
        JobChangeEvent instance = new JobChangeEvent();
        instance.job = job;
        return instance;
    }

    static JobChangeEvent newEvent(Job job, IStatus result) {
        JobChangeEvent instance = new JobChangeEvent();
        instance.job = job;
        instance.result = result;
        return instance;
    }

    static JobChangeEvent newEvent(Job job, long delay) {
        JobChangeEvent instance = new JobChangeEvent();
        instance.job = job;
        instance.delay = delay;
        return instance;
    }

    private void doNotify(final IListenerDoit doit, final IJobChangeEvent event) {
        InternalPlatform.getDefault().run(new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                int size = JobListeners.this.global.size();
                int i = 0;
                while (i < size) {
                    IJobChangeListener listener = null;
                    try {
                        listener = (IJobChangeListener)JobListeners.this.global.get(i);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    if (listener != null) {
                        doit.notify(listener, event);
                    }
                    ++i;
                }
                List local = event.getJob().getListeners();
                if (local != null) {
                    size = local.size();
                    int i2 = 0;
                    while (i2 < size) {
                        IJobChangeListener listener = null;
                        try {
                            listener = (IJobChangeListener)local.get(i2);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                        if (listener != null) {
                            doit.notify(listener, event);
                        }
                        ++i2;
                    }
                }
            }
        });
    }

    public void add(IJobChangeListener listener) {
        this.global.add(listener);
    }

    public void remove(IJobChangeListener listener) {
        this.global.remove(listener);
    }

    public void aboutToRun(Job job) {
        this.doNotify(this.aboutToRun, JobListeners.newEvent(job));
    }

    public void awake(Job job) {
        this.doNotify(this.awake, JobListeners.newEvent(job));
    }

    public void done(Job job, IStatus result) {
        this.doNotify(this.done, JobListeners.newEvent(job, result));
    }

    public void running(Job job) {
        this.doNotify(this.running, JobListeners.newEvent(job));
    }

    public void scheduled(Job job, long delay) {
        this.doNotify(this.scheduled, JobListeners.newEvent(job, delay));
    }

    public void sleeping(Job job) {
        this.doNotify(this.sleeping, JobListeners.newEvent(job));
    }

    interface IListenerDoit {
        public void notify(IJobChangeListener var1, IJobChangeEvent var2);
    }
}

