/*==================================================================
 * ippriv.h - Private header file
 *
 * libInstPatch
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 *==================================================================*/
#ifndef __IPPRIV_H__
#define __IPPRIV_H__

#include "instpatch.h"

/* not yet enabled */
#define ITEM_READ_LOCK(mutex)
#define ITEM_READ_UNLOCK(mutex)
#define ITEM_WRITE_LOCK(mutex)
#define ITEM_WRITE_UNLOCK(mutex)

static int
ret_g_log (const gchar *log_domain, GLogLevelFlags log_level,
	   const gchar *format, ...)
{
  va_list args;
  va_start (args, format);
  g_logv (log_domain, log_level, format, args);
  va_end (args);

  return (TRUE);
}


#ifdef __GNUC__

#define log_if_fail(expr)  (!(expr) && \
      ret_g_log (G_LOG_DOMAIN, G_LOG_LEVEL_CRITICAL, \
	     "file %s: line %d (%s): assertion `%s' failed.", \
	     __FILE__, __LINE__, __PRETTY_FUNCTION__, \
	     #expr))

#else  /* !GNUC */

#define log_if_fail(expr)  (!(expr) && \
      ret_g_log (G_LOG_DOMAIN, G_LOG_LEVEL_CRITICAL, \
	     "file %s: line %d: assertion `%s' failed.", \
	     __FILE__, __LINE__, \
	     #expr))
#endif

#define IPERR_MSG_BAD_PARAM_1 "Invalid value for function parameter \"%s\""

/* size of buffers used for transfering sample data (in bytes) */
#define INSTP_SAMPLE_COPY_BUFFER_SIZE  (32 * 1024)

extern IPSampleData *instp_sample_data_list;

#endif
