/*
 * \file SwamiUISampleView.h
 * \brief Sample view object header file
 */

/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SWAMIUI_SAMPLE_VIEW_H__
#define __SWAMIUI_SAMPLE_VIEW_H__

#include <gtk/gtk.h>
#include <instpatch.h>

#include "swamidll.h"

typedef struct _SwamiUISampleView SwamiUISampleView;
typedef struct _SwamiUISampleViewClass SwamiUISampleViewClass;

#define SWAMIUI_TYPE_SAMPLEVIEW   (swamiui_sampleview_get_type ())
#define SWAMIUI_SAMPLEVIEW(obj) \
  (GTK_CHECK_CAST ((obj), SWAMIUI_TYPE_SAMPLEVIEW, SwamiUISampleView))
#define SWAMIUI_SAMPLEVIEW_CLASS(klass) \
  (GTK_CHECK_CLASS_CAST ((klass), SWAMIUI_TYPE_SAMPLEVIEW, \
  SwamiUISampleViewClass))
#define SWAMIUI_IS_SAMPLEVIEW(obj) \
  (GTK_CHECK_TYPE ((obj), SWAMIUI_TYPE_SAMPLEVIEW))
#define SWAMIUI_IS_SAMPLEVIEW_CLASS(klass) \
  (GTK_CHECK_CLASS_TYPE ((klass), SWAMIUI_TYPE_SAMPLEVIEW))

/** Sample view object */
struct _SwamiUISampleView
{
  GtkVBox parent;		/* derived from GtkVBox */

  IPItem *item;			/* item to sync to (sample or inst zone) */

  GtkWidget *samview;		/* the actual samview widget */
  GtkWidget *ptrstrip;		/* pointer strip widget for sample view */
  GtkWidget *loopmenu;		/* loop toggle button */
  GtkWidget *cut_btn;		/* the sample "cut" button */
  GtkWidget *spinbtns[6];	/* spin buttons, only 4 used */
};

/** Sample view object class */
struct _SwamiUISampleViewClass
{
  GtkVBoxClass parent_class;
};

SWAMI_API guint swamiui_sampleview_get_type (void);
SWAMI_API GtkWidget *swamiui_sampleview_new (void);
SWAMI_API void swamiui_sampleview_set_item (SwamiUISampleView *sampleview,
					    IPItem *item);
SWAMI_API void swamiui_sampleview_update (SwamiUISampleView *sampleview);

#endif
