/**
 * \file SwamiUIProp.h
 * \brief UI Sound font item properties object header file
 *
 * Provides user interface elements for modifying properties of
 * sound font items.
 */

/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SWAMIUI_PROP_H__
#define __SWAMIUI_PROP_H__

#include <gtk/gtk.h>
#include <instpatch.h>

#include "swamidll.h"

typedef struct _SwamiUIProp SwamiUIProp;
typedef struct _SwamiUIPropClass SwamiUIPropClass;

#define SWAMIUI_TYPE_PROP   (swamiui_prop_get_type ())
#define SWAMIUI_PROP(obj) \
  (GTK_CHECK_CAST ((obj), SWAMIUI_TYPE_PROP, SwamiUIProp))
#define SWAMIUI_PROP_CLASS(klass) \
  (GTK_CHECK_CLASS_CAST ((klass), SWAMIUI_TYPE_PROP, SwamiUIPropClass))
#define SWAMIUI_IS_PROP(obj) \
  (GTK_CHECK_TYPE ((obj), SWAMIUI_TYPE_PROP))
#define SWAMIUI_IS_PROP_CLASS(klass) \
  (GTK_CHECK_CLASS_TYPE ((klass), SWAMIUI_TYPE_PROP))

/** Swami Properties Object (all fields private) */
struct _SwamiUIProp
{
  GtkVBox parent;		/* derived from GtkVBox */
  GtkWidget *glade_widg;	/* current glade properties widget */
  IPItem *item;			/* patch item to set properties for */
};

/** Swami Properties Object class (all fields private) */
struct _SwamiUIPropClass
{
  GtkVBoxClass parent_class;	/* class derived from GtkVBoxClass */
};

SWAMI_API guint swamiui_prop_get_type (void);
SWAMI_API GtkWidget *swamiui_prop_new (void);

SWAMI_API gboolean swamiui_prop_item_supported (int type);
SWAMI_API void swamiui_prop_set_item (SwamiUIProp *prop, IPItem *item);
SWAMI_API GtkWidget *swamiui_prop_create_widget (SwamiUIProp *prop,
						 IPItem *item);
SWAMI_API void swamiui_prop_update (SwamiUIProp *prop);
SWAMI_API gboolean swamiui_prop_commit (SwamiUIProp *prop, char **err_msg);
SWAMI_API gboolean swamiui_prop_is_valid (SwamiUIProp *prop, char **err_msg);

#endif
